/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.page;

import com.taotao.boot.data.mybatis.interceptor.page.Paginable;

public class Page<T>
implements Paginable<T> {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int PAGE_COUNT = 10;
    private int pageNo = 1;
    private int pageSize = 10;
    private int totalCount = 0;
    private int totalPage = 0;
    private long timestamp = 0L;
    private boolean full = false;

    @Override
    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
        int totalPage = totalCount % this.pageSize == 0 ? totalCount / this.pageSize : totalCount / this.pageSize + 1;
        this.setTotalPage(totalPage);
    }

    @Override
    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    @Override
    public boolean isFirstPage() {
        return this.pageNo <= 1;
    }

    @Override
    public boolean isLastPage() {
        return this.pageNo >= this.totalPage;
    }

    @Override
    public int getNextPage() {
        return this.isLastPage() ? this.pageNo : this.pageNo + 1;
    }

    @Override
    public int getPrePage() {
        return this.isFirstPage() ? this.pageNo : this.pageNo - 1;
    }

    @Override
    public int getBeginIndex() {
        if (this.pageNo > 0) {
            return this.pageSize * (this.pageNo - 1);
        }
        return 0;
    }

    @Override
    public int getEndIndex() {
        if (this.pageNo > 0) {
            return Math.min(this.pageSize * this.pageNo, this.totalCount);
        }
        return 0;
    }

    @Override
    public int getBeginPage() {
        if (this.pageNo > 0) {
            return 10 * ((this.pageNo - 1) / 10) + 1;
        }
        return 0;
    }

    @Override
    public int getEndPage() {
        if (this.pageNo > 0) {
            return Math.min(10 * ((this.pageNo - 1) / 10 + 1), this.getTotalPage());
        }
        return 0;
    }

    public boolean isFull() {
        return this.full;
    }

    public void setFull(boolean full) {
        this.full = full;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

