/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.page;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.data.mybatis.interceptor.page.Page;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.reflect.FieldUtil;

@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class})})
public class PaginableInterceptor
implements Interceptor {
    private String databaseType;

    public Object intercept(Invocation invocation) throws Throwable {
        RoutingStatementHandler handler = (RoutingStatementHandler)invocation.getTarget();
        StatementHandler delegate = (StatementHandler)ReflectionUtils.getFieldValue((Object)handler, (String)"delegate");
        BoundSql boundSql = delegate.getBoundSql();
        Object parameterObject = boundSql.getParameterObject();
        if (parameterObject instanceof Page) {
            Page page = (Page)parameterObject;
            MappedStatement mappedStatement = (MappedStatement)ReflectionUtils.getFieldValue((Object)delegate, (String)"mappedStatement");
            Connection connection = (Connection)invocation.getArgs()[0];
            String sql = boundSql.getSql();
            if (page.isFull()) {
                this.setTotalCount(page, mappedStatement, connection);
            }
            page.setTimestamp(System.currentTimeMillis());
            String pageSql = this.getPageSql(page, sql);
            FieldUtil.setFieldValue((Object)boundSql, (String)"sql", (Object)pageSql);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.databaseType = properties.getProperty("databaseType");
    }

    private String getPageSql(Page<?> page, String sql) {
        StringBuffer sqlBuffer = new StringBuffer(sql);
        if ("mysql".equalsIgnoreCase(this.databaseType)) {
            return this.getMysqlPageSql(page, sqlBuffer);
        }
        if ("oracle".equalsIgnoreCase(this.databaseType)) {
            return this.getOraclePageSql(page, sqlBuffer);
        }
        if ("hsqldb".equalsIgnoreCase(this.databaseType)) {
            return this.getHSQLDBPageSql(page, sqlBuffer);
        }
        return sqlBuffer.toString();
    }

    private String getMysqlPageSql(Page<?> page, StringBuffer sqlBuffer) {
        int offset = (page.getPageNo() - 1) * page.getPageSize();
        sqlBuffer.append(" limit ").append(offset).append(",").append(page.getPageSize());
        return sqlBuffer.toString();
    }

    private String getOraclePageSql(Page<?> page, StringBuffer sqlBuffer) {
        int offset = (page.getPageNo() - 1) * page.getPageSize() + 1;
        sqlBuffer.insert(0, "select u.*, rownum r from (").append(") u where rownum < ").append(offset + page.getPageSize());
        sqlBuffer.insert(0, "select * from (").append(") where r >= ").append(offset);
        return sqlBuffer.toString();
    }

    private String getHSQLDBPageSql(Page<?> page, StringBuffer sqlBuffer) {
        int offset = (page.getPageNo() - 1) * page.getPageSize() + 1;
        return "select limit " + offset + " " + page.getPageSize() + " * from (" + sqlBuffer.toString() + " )";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTotalCount(Page<?> page, MappedStatement mappedStatement, Connection connection) {
        ResultSet rs;
        PreparedStatement pstmt;
        block4: {
            BoundSql boundSql = mappedStatement.getBoundSql(page);
            String sql = boundSql.getSql();
            String countSql = this.getCountSql(sql);
            List parameterMappings = boundSql.getParameterMappings();
            BoundSql countBoundSql = new BoundSql(mappedStatement.getConfiguration(), countSql, parameterMappings, page);
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, page, countBoundSql);
            pstmt = null;
            rs = null;
            try {
                pstmt = connection.prepareStatement(countSql);
                parameterHandler.setParameters(pstmt);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                int totalCount = rs.getInt(1);
                page.setTotalCount(totalCount);
            }
            catch (SQLException e) {
                try {
                    LogUtils.error((Throwable)e);
                }
                catch (Throwable throwable) {
                    IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{rs});
                    IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{pstmt});
                    throw throwable;
                }
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{rs});
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{pstmt});
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{rs});
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{pstmt});
    }

    private String getCountSql(String sql) {
        return "select count(1) " + sql.substring(sql.toLowerCase().indexOf("from"));
    }
}

