/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sql;

import com.taotao.boot.common.utils.log.LogUtils;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import java.util.List;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.logging.jdbc.PreparedStatementLogger;
import org.apache.ibatis.logging.jdbc.StatementLogger;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.dromara.hutool.core.reflect.FieldUtil;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class BigResultQueryInterceptor
implements Interceptor {
    private Boolean flag;
    private Integer threshold;

    public BigResultQueryInterceptor() {
    }

    public BigResultQueryInterceptor(Boolean flag, Integer threshold) {
        this.flag = flag;
        this.threshold = threshold;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        Object result = invocation.proceed();
        String sql = "";
        try {
            if (this.flag.booleanValue()) {
                Statement statement = (Statement)invocation.getArgs()[0];
                if (Proxy.isProxyClass(statement.getClass())) {
                    MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
                    Object h = metaObject.getValue("h");
                    if (h instanceof StatementLogger) {
                        RoutingStatementHandler rsh = (RoutingStatementHandler)invocation.getTarget();
                        sql = rsh.getBoundSql().getSql();
                    } else if (h instanceof PreparedStatementLogger) {
                        PreparedStatementLogger psl = (PreparedStatementLogger)h;
                        sql = (String)FieldUtil.getFieldValue((Object)psl.getPreparedStatement(), (String)"sql");
                    }
                } else {
                    sql = statement.toString();
                }
                if (result instanceof List && ((List)result).size() >= this.threshold) {
                    LogUtils.warn((String)"\u6570\u636e\u5e93\u67e5\u8be2\u7ed3\u679c\u96c6 {} \u6761\uff0c\u5b58\u5728\u5185\u5b58\u6cc4\u9732\u98ce\u9669\uff0c\u8bf7\u4f7f\u7528\u5206\u9875\u67e5\u8be2\u3002", (Object[])new Object[]{((List)result).size()});
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }
}

