/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sql;

import com.taotao.boot.common.utils.log.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.statement.BaseStatementHandler;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.beans.factory.annotation.Value;

@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class})})
public class SQLMarkingInterceptor
implements Interceptor {
    private static final int DEFAULT_INDEX = 2;
    @Value(value="sql.marking.enable")
    private boolean enabled;
    private static final Map<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>();

    public Object intercept(Invocation invocation) throws Throwable {
        if (!this.enabled) {
            return invocation.proceed();
        }
        try {
            RoutingStatementHandler routingStatementHandler = this.getRoutingStatementHandler(invocation.getTarget());
            if (routingStatementHandler != null) {
                StatementHandler delegate = this.getFieldValue(RoutingStatementHandler.class, routingStatementHandler, "delegate", StatementHandler.class);
                this.marking(delegate);
            }
        }
        catch (Exception e) {
            LogUtils.error((String)e.getMessage(), (Object[])new Object[]{e});
        }
        return invocation.proceed();
    }

    private RoutingStatementHandler getRoutingStatementHandler(Object target) throws NoSuchFieldException, IllegalAccessException {
        while (Proxy.isProxyClass(target.getClass())) {
            target = Proxy.getInvocationHandler(target);
        }
        while (target instanceof Plugin) {
            Plugin plugin = (Plugin)target;
            target = this.getFieldValue(Plugin.class, plugin, "target", Object.class);
        }
        if (target instanceof RoutingStatementHandler) {
            return (RoutingStatementHandler)target;
        }
        return null;
    }

    private void marking(StatementHandler delegate) throws NoSuchFieldException, IllegalAccessException {
        BoundSql boundSql = delegate.getBoundSql();
        String sql = boundSql.getSql().trim();
        if (StringUtils.containsIgnoreCase((CharSequence)sql, (CharSequence)"select")) {
            MappedStatement mappedStatement = this.getFieldValue(BaseStatementHandler.class, delegate, "mappedStatement", MappedStatement.class);
            String mappedStatementId = mappedStatement.getId();
            String trace = this.trace();
            LinkedHashMap<String, String> markingMap = new LinkedHashMap<String, String>();
            markingMap.put("STATEMENT_ID", mappedStatementId);
            markingMap.put("STACK_TRACE", trace);
            String marking = "[SQLMarking] ".concat(markingMap.toString());
            sql = String.format(" /* %s */ %s", marking, sql);
            Field field = this.getField(BoundSql.class, "sql");
            field.set(boundSql, sql);
        }
    }

    private <T> T getFieldValue(Class<?> clazz, Object object, String fieldName, Class<T> fieldClass) throws NoSuchFieldException, IllegalAccessException {
        Field field = this.getField(clazz, fieldName);
        return fieldClass.cast(field.get(object));
    }

    private String trace() {
        StackTraceElement[] stackTraceArray = Thread.currentThread().getStackTrace();
        if (stackTraceArray.length <= 2) {
            return "";
        }
        LinkedList<String> methodInfoList = new LinkedList<String>();
        for (int i = stackTraceArray.length - 1 - 2; i >= 2; --i) {
            StackTraceElement stackTraceElement = stackTraceArray[i];
            String className = stackTraceElement.getClassName();
            if (!className.startsWith("com.your.package") || className.contains("FastClassBySpringCGLIB") || className.contains("EnhancerBySpringCGLIB") || stackTraceElement.getMethodName().contains("lambda$") || className.contains("Interceptor") || className.contains("Aspect")) continue;
            String methodInfo = String.format("%s#%s", className.substring(className.lastIndexOf(46) + 1), stackTraceElement.getMethodName());
            methodInfoList.add(methodInfo);
        }
        if (methodInfoList.isEmpty()) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(" ==> ");
        for (String method : methodInfoList) {
            stringJoiner.add(method);
        }
        return stringJoiner.toString();
    }

    private Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field field;
        String cacheKey = String.format("%s.%s", clazz.getName(), fieldName);
        if (FIELD_CACHE.containsKey(cacheKey)) {
            field = FIELD_CACHE.get(cacheKey);
        } else {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            FIELD_CACHE.put(cacheKey, field);
        }
        return field;
    }
}

