/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sql;

import com.taotao.boot.common.utils.log.LogUtils;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;

@Intercepts(value={@Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class})})
public class SlowQueryInterceptor
implements Interceptor {
    private Boolean flag;
    private long slowSqlThresholdMs;

    public SlowQueryInterceptor() {
    }

    public SlowQueryInterceptor(Boolean flag, long slowSqlThresholdMs) {
        this.flag = flag;
        this.slowSqlThresholdMs = slowSqlThresholdMs;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        long sqlStartTime = System.currentTimeMillis();
        Object re = null;
        try {
            re = invocation.proceed();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        long sqlEndTime = System.currentTimeMillis();
        long executeTime = sqlEndTime - sqlStartTime;
        if (this.flag.booleanValue() && executeTime >= this.slowSqlThresholdMs) {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            Object parameter = null;
            if (invocation.getArgs().length > 1) {
                parameter = invocation.getArgs()[1];
            }
            String sqlId = mappedStatement.getId();
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            Configuration configuration = mappedStatement.getConfiguration();
            String sql = SlowQueryInterceptor.assembleSql(configuration, boundSql);
            LogUtils.warn((String)"SQL\u6267\u884c\u8017\u65f6: [{}] ,\u5b58\u5728\u6162SQL\u98ce\u9669,\u6267\u884c\u65b9\u6cd5: [{}], sql: [{}]", (Object[])new Object[]{executeTime + " ms", sqlId, sql});
        }
        return re;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    private static String assembleSql(Configuration configuration, BoundSql boundSql) {
        Object sqlParameter = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (!parameterMappings.isEmpty() && sqlParameter != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(sqlParameter.getClass())) {
                sql = sql.replaceFirst("\\?", SlowQueryInterceptor.getParameterValue(sqlParameter));
            } else {
                MetaObject metaObject = configuration.newMetaObject(sqlParameter);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", SlowQueryInterceptor.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", SlowQueryInterceptor.getParameterValue(obj));
                }
            }
        }
        return sql;
    }

    private static String getParameterValue(Object obj) {
        Object value;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value != null ? SlowQueryInterceptor.makeQueryStringAllRegExp((String)value) : null;
    }

    private static String makeQueryStringAllRegExp(String str) {
        if (str != null && !str.equals("")) {
            return str.replace("\\", "\\\\").replace("*", "\\*").replace("+", "\\+").replace("|", "\\|").replace("{", "\\{").replace("}", "\\}").replace("(", "\\(").replace(")", "\\)").replace("^", "\\^").replace("$", "\\$").replace("[", "\\[").replace("]", "\\]").replace("?", "\\?").replace(",", "\\,").replace(".", "\\.").replace("&", "\\&");
        }
        return str;
    }
}

