/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sql;

import com.taotao.boot.common.utils.log.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.defaults.DefaultSqlSession;

@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class SlowSqlInterceptor
implements Interceptor {
    private Integer limitSecond = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws InvocationTargetException, IllegalAccessException {
        long beginTimeMillis = System.currentTimeMillis();
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long costTimeMillis = endTimeMillis - beginTimeMillis;
            BoundSql boundSql = statementHandler.getBoundSql();
            String sql = this.getFormatedSql(boundSql);
            LogUtils.info((String)("SQL\u8bed\u53e5\u3010" + sql + "\u3011\uff0c\u6267\u884c\u8017\u65f6\uff1a" + costTimeMillis + "ms"), (Object[])new Object[0]);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String limitSecond = (String)properties.getOrDefault((Object)"limitSecond", (Object)100);
        this.limitSecond = Integer.parseInt(limitSecond);
    }

    private String getFormatedSql(BoundSql boundSql) {
        String sql = boundSql.getSql();
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        sql = this.beautifySql(sql);
        if (parameterObject == null || parameterMappings == null || parameterMappings.isEmpty()) {
            return sql;
        }
        String sqlWithoutReplacePlaceholder = sql;
        try {
            Class<?> parameterObjectClass = parameterObject.getClass();
            if (this.isStrictMap(parameterObjectClass)) {
                DefaultSqlSession.StrictMap strictMap = (DefaultSqlSession.StrictMap)parameterObject;
                if (this.isList(((Collection)strictMap.get((Object)"list")).getClass())) {
                    sql = this.handleListParameter(sql, (Collection)strictMap.get((Object)"list"));
                }
            } else if (this.isMap(parameterObjectClass)) {
                Map paramMap = (Map)parameterObject;
                sql = this.handleMapParameter(sql, paramMap, parameterMappings);
            } else {
                sql = this.handleCommonParameter(sql, parameterMappings, parameterObjectClass, parameterObject);
            }
        }
        catch (Exception e) {
            return sqlWithoutReplacePlaceholder;
        }
        return sql;
    }

    private String beautifySql(String sql) {
        sql = sql.replace("\n", "").replace("\t", "").replace("  ", " ").replace("( ", "(").replace(" )", ")").replace(" ,", ",");
        return sql;
    }

    private String handleListParameter(String sql, Collection<?> col) {
        if (col != null && !col.isEmpty()) {
            for (Object obj : col) {
                Object value = null;
                Class<String> objClass = obj.getClass();
                if (this.isPrimitiveOrPrimitiveWrapper(objClass)) {
                    value = obj.toString();
                } else if (objClass.isAssignableFrom(String.class)) {
                    value = "\"" + obj.toString() + "\"";
                }
                sql = sql.replaceFirst("\\?", (String)value);
            }
        }
        return sql;
    }

    private String handleMapParameter(String sql, Map<?, ?> paramMap, List<ParameterMapping> parameterMappingList) {
        for (ParameterMapping parameterMapping : parameterMappingList) {
            String propertyName = parameterMapping.getProperty();
            Object propertyValue = paramMap.get(propertyName);
            if (propertyValue == null) continue;
            if (propertyValue.getClass().isAssignableFrom(String.class)) {
                propertyValue = "\"" + String.valueOf(propertyValue) + "\"";
            }
            sql = sql.replaceFirst("\\?", propertyValue.toString());
        }
        return sql;
    }

    private String handleCommonParameter(String sql, List<ParameterMapping> parameterMappingList, Class<?> parameterObjectClass, Object parameterObject) throws Exception {
        for (ParameterMapping parameterMapping : parameterMappingList) {
            Object propertyValue = null;
            if (this.isPrimitiveOrPrimitiveWrapper(parameterObjectClass)) {
                propertyValue = parameterObject.toString();
            } else {
                String propertyName = parameterMapping.getProperty();
                Field field = parameterObjectClass.getDeclaredField(propertyName);
                field.setAccessible(true);
                propertyValue = String.valueOf(field.get(parameterObject));
                if (parameterMapping.getJavaType().isAssignableFrom(String.class)) {
                    propertyValue = "\"" + (String)propertyValue + "\"";
                }
            }
            sql = sql.replaceFirst("\\?", (String)propertyValue);
        }
        return sql;
    }

    private boolean isPrimitiveOrPrimitiveWrapper(Class<?> parameterObjectClass) {
        return parameterObjectClass.isPrimitive() || parameterObjectClass.isAssignableFrom(Byte.class) || parameterObjectClass.isAssignableFrom(Short.class) || parameterObjectClass.isAssignableFrom(Integer.class) || parameterObjectClass.isAssignableFrom(Long.class) || parameterObjectClass.isAssignableFrom(Double.class) || parameterObjectClass.isAssignableFrom(Float.class) || parameterObjectClass.isAssignableFrom(Character.class) || parameterObjectClass.isAssignableFrom(Boolean.class);
    }

    private boolean isStrictMap(Class<?> parameterObjectClass) {
        return parameterObjectClass.isAssignableFrom(DefaultSqlSession.StrictMap.class);
    }

    private boolean isList(Class<?> clazz) {
        Class<?>[] interfaceClasses;
        for (Class<List> clazz2 : interfaceClasses = clazz.getInterfaces()) {
            if (!clazz2.isAssignableFrom(List.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isMap(Class<?> parameterObjectClass) {
        Class<?>[] interfaceClasses;
        for (Class<Map> clazz : interfaceClasses = parameterObjectClass.getInterfaces()) {
            if (!clazz.isAssignableFrom(Map.class)) continue;
            return true;
        }
        return false;
    }
}

