/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sql;

import com.taotao.boot.common.utils.log.LogUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(method="queryCursor", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class}), @Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class}), @Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=StatementHandler.class, method="parameterize", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="queryCursor", args={Statement.class}), @Signature(type=ParameterHandler.class, method="getParameterObject", args={}), @Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class}), @Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class}), @Signature(type=ResultSetHandler.class, method="handleCursorResultSets", args={Statement.class})})
public class SqlValidateInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        Method method = invocation.getMethod();
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        String sql = boundSql.getSql();
        LogUtils.info((String)"\u6821\u9a8csql -------------------------- start", (Object[])new Object[0]);
        SqlValidateInterceptor.validateSQL4(sql);
        LogUtils.info((String)"\u6821\u9a8csql -------------------------- success", (Object[])new Object[0]);
        return invocation.proceed();
    }

    public static boolean validateSQL4(String sql) throws SQLException {
        try {
            SqlParser.Config config = SqlParser.config();
            SqlParserImplFactory factory = config.parserFactory();
            SqlParser parser = SqlParser.create((String)sql, (SqlParser.Config)config.withParserFactory(factory));
            SqlNode node = parser.parseStmt();
            return true;
        }
        catch (SqlParseException e) {
            throw new SQLException("sql\u8bed\u6cd5\u9519\u8bef");
        }
    }

    public static boolean validateSQL3(String sql) throws SQLException {
        try {
            CodePointCharStream input = CharStreams.fromString((String)sql);
            return true;
        }
        catch (Exception e) {
            throw new SQLException("sql\u8bed\u6cd5\u9519\u8bef");
        }
    }

    public static boolean validateSQL2(String sql) throws SQLException {
        try {
            net.sf.jsqlparser.statement.Statement stmt = CCJSqlParserUtil.parse((String)sql);
            return true;
        }
        catch (JSQLParserException e) {
            throw new SQLException("sql\u8bed\u6cd5\u9519\u8bef");
        }
    }

    public static boolean validateSQL1(String sql) throws SQLException {
        try {
            Connection conn = DriverManager.getConnection("jdbc:mysql://127.0.0.1:3306/mydatabase", "username", "password");
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            return true;
        }
        catch (SQLException e) {
            throw new SQLException("sql\u8bed\u6cd5\u9519\u8bef");
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

