/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis.SqlAnalysisResult;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis.SqlAnalysisResultList;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.extract.SqlExtractResult;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.GsonUtil;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.MysqlVersion;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlAnalysis {
    private static Logger logger = LoggerFactory.getLogger(SqlAnalysis.class);
    private static String mysqlVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlAnalysisResultList analysis(SqlExtractResult sqlExtractResult, Connection connection) {
        if (sqlExtractResult == null) {
            return null;
        }
        String sourceSql = sqlExtractResult.getSourceSql();
        ArrayList<SqlAnalysisResult> resultList = new ArrayList<SqlAnalysisResult>();
        SqlAnalysisResult sqlAnalysisResutlDto = null;
        String analysisSql = SqlAnalysis.getAnalysisSql(sourceSql);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement(analysisSql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                sqlAnalysisResutlDto = SqlAnalysis.convertSqlAnalysisResultDto(rs);
                resultList.add(sqlAnalysisResutlDto);
            }
        }
        catch (SQLException e) {
            LogUtils.error((Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                LogUtils.error((Throwable)e);
            }
        }
        logger.info("sql analysis result = " + GsonUtil.bean2Json(sqlAnalysisResutlDto));
        SqlAnalysisResultList sqlAnalysisResultList = new SqlAnalysisResultList();
        sqlAnalysisResultList.setResultList(resultList);
        return sqlAnalysisResultList;
    }

    private static SqlAnalysisResult convertSqlAnalysisResultDto(ResultSet resultSet) {
        SqlAnalysisResult sqlAnalysisResult = new SqlAnalysisResult();
        if (resultSet == null) {
            return null;
        }
        try {
            if (StringUtils.isBlank((CharSequence)mysqlVersion)) {
                mysqlVersion = SqlAnalysis.getMysqlVersion(resultSet);
            }
            Long id = resultSet.getLong("id");
            String selectType = resultSet.getString("select_type");
            String table = resultSet.getString("table");
            String type = resultSet.getString("type");
            String possibleKeys = resultSet.getString("possible_keys");
            String key = resultSet.getString("key");
            String keyLen = resultSet.getString("key_len");
            String ref = resultSet.getString("ref");
            String rows = resultSet.getString("rows");
            String extra = resultSet.getString("Extra");
            sqlAnalysisResult.setId(id);
            sqlAnalysisResult.setSelectType(selectType);
            sqlAnalysisResult.setTable(table);
            sqlAnalysisResult.setType(type);
            sqlAnalysisResult.setPossibleKeys(possibleKeys);
            sqlAnalysisResult.setKey(key);
            sqlAnalysisResult.setKeyLen(keyLen);
            sqlAnalysisResult.setRef(ref);
            sqlAnalysisResult.setRows(rows);
            sqlAnalysisResult.setExtra(extra);
            if (mysqlVersion.equals(MysqlVersion.MYSQL_5_7.getVersion())) {
                Double filtered = resultSet.getDouble("filtered");
                String partitions = resultSet.getString("partitions");
                sqlAnalysisResult.setPartitions(partitions);
                sqlAnalysisResult.setFiltered(filtered);
            }
        }
        catch (SQLException e) {
            logger.error("sql analysis convert error", (Throwable)e);
            LogUtils.error((Throwable)e);
        }
        return sqlAnalysisResult;
    }

    private static String getAnalysisSql(String sql) {
        sql = "explain " + (String)sql;
        return sql;
    }

    public boolean isExistColumn(ResultSet rs, String columnName) {
        try {
            if (rs.findColumn(columnName) > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    public static String getMysqlVersion(ResultSet rs) {
        String mysqlVersion = MysqlVersion.MYSQL_5_6.getVersion();
        try {
            int columnCount = rs.getMetaData().getColumnCount();
            if (columnCount > 10) {
                mysqlVersion = MysqlVersion.MYSQL_5_7.getVersion();
            }
        }
        catch (Exception e) {
            logger.error("sql analysis \u83b7\u53d6mysql\u7248\u672c\u5f02\u5e38", (Throwable)e);
        }
        return mysqlVersion;
    }
}

