/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sqlanalysis.config;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmqConfig {
    private static Logger logger = LoggerFactory.getLogger(JmqConfig.class);
    private static String app;
    private static String user;
    private static String password;
    private static String address;
    private static String topic;
    private static String MQ_APP;
    private static String MQ_USER;
    private static String MQ_PASSWORD;
    private static String MQ_ADDRESS;
    private static String MQ_TOPIC;

    public static void initConfig(Properties properties) {
        boolean result = JmqConfig.checkConfig(properties);
        if (result) {
            app = properties.getProperty(MQ_APP);
            user = properties.getProperty(MQ_USER);
            password = properties.getProperty(MQ_PASSWORD);
            address = properties.getProperty(MQ_ADDRESS);
            topic = properties.getProperty(MQ_TOPIC);
        }
    }

    private static boolean checkConfig(Properties properties) {
        if (properties == null) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)properties.getProperty(MQ_APP)) && !StringUtils.isBlank((CharSequence)properties.getProperty(MQ_USER)) && !StringUtils.isBlank((CharSequence)properties.getProperty(MQ_PASSWORD)) && !StringUtils.isBlank((CharSequence)properties.getProperty(MQ_ADDRESS)) && !StringUtils.isBlank((CharSequence)properties.getProperty(MQ_TOPIC));
    }

    public static boolean initMqProducer() {
        try {
            return true;
        }
        catch (Exception e) {
            logger.error("sql analysis mq config init error");
            return false;
        }
    }

    public static String getApp() {
        return app;
    }

    public static void setApp(String app) {
        JmqConfig.app = app;
    }

    public static String getUser() {
        return user;
    }

    public static void setUser(String user) {
        JmqConfig.user = user;
    }

    public static String getPassword() {
        return password;
    }

    public static void setPassword(String password) {
        JmqConfig.password = password;
    }

    public static String getAddress() {
        return address;
    }

    public static void setAddress(String address) {
        JmqConfig.address = address;
    }

    public static String getTopic() {
        return topic;
    }

    public static void setTopic(String topic) {
        JmqConfig.topic = topic;
    }

    static {
        MQ_APP = "mqApp";
        MQ_USER = "mqUser";
        MQ_PASSWORD = "mqPassword";
        MQ_ADDRESS = "mqAddress";
        MQ_TOPIC = "mqTopic";
    }
}

