/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sqlanalysis.config;

import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis.SqlAnalysisSqlTypeEnum;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.config.JmqConfig;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.rule.SqlScoreRule;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.DuccMonitorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlAnalysisConfig {
    private static Logger logger = LoggerFactory.getLogger(SqlAnalysisConfig.class);
    private static Boolean analysisSwitch = false;
    private static Boolean onlyCheckOnce = true;
    private static Long checkInterval = 300000L;
    private static List<String> exceptSqlIds = new ArrayList<String>();
    private static List<String> sqlType = new ArrayList<String>();
    private static String scoreRuleLoadClass;
    private static String outputModel;
    private static String outputClass;
    private static String appName;
    private static Boolean sqlReplaceModelSwitch;
    private static final String ANALYSIS_SWITCH_KEY = "analysisSwitch";
    private static final String ONLY_CHECK_ONCE = "onlyCheckOnce";
    private static final String CHECK_INTERVAL = "checkInterval";
    private static final String EXCEPT_SQL_IDS_KEY = "exceptSqlIds";
    private static final String SQL_TYPE_KEY = "sqlType";
    private static final String SCORE_RULE_LOAD_KEY = "scoreRuleLoadClass";
    private static final String OUTPUT_CLASS_KEY = "outputClass";
    private static final String OUTPUT_MODEL_KEY = "outputModel";
    private static final String APP_NAME = "appName";
    private static List<SqlScoreRule> ruleList;

    public static void init(Properties properties) {
        try {
            if (StringUtils.isBlank((CharSequence)properties.getProperty(SQL_TYPE_KEY))) {
                sqlType.add(SqlAnalysisSqlTypeEnum.SELECT.getType());
                sqlType.add(SqlAnalysisSqlTypeEnum.UPDATE.getType());
            } else {
                Object[] sqlTypes = properties.getProperty(SQL_TYPE_KEY).split(",");
                CollectionUtils.addAll(sqlType, (Object[])sqlTypes);
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getProperty(ANALYSIS_SWITCH_KEY))) {
                analysisSwitch = Boolean.valueOf(properties.getProperty(ANALYSIS_SWITCH_KEY));
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getProperty(ONLY_CHECK_ONCE))) {
                onlyCheckOnce = Boolean.valueOf(properties.getProperty(ONLY_CHECK_ONCE));
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getProperty(CHECK_INTERVAL))) {
                checkInterval = Long.valueOf(properties.getProperty(CHECK_INTERVAL));
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getProperty(SCORE_RULE_LOAD_KEY))) {
                scoreRuleLoadClass = properties.getProperty(SCORE_RULE_LOAD_KEY);
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getProperty(OUTPUT_CLASS_KEY))) {
                outputClass = properties.getProperty(OUTPUT_CLASS_KEY);
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getProperty(OUTPUT_MODEL_KEY))) {
                outputModel = properties.getProperty(OUTPUT_MODEL_KEY);
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getProperty(EXCEPT_SQL_IDS_KEY))) {
                Object[] exceptIds = properties.getProperty(EXCEPT_SQL_IDS_KEY).split(",");
                CollectionUtils.addAll(exceptSqlIds, (Object[])exceptIds);
            }
            appName = StringUtils.isNotBlank((CharSequence)properties.getProperty(APP_NAME)) ? properties.getProperty(APP_NAME) : "default";
            if (StringUtils.isNotBlank((CharSequence)properties.getProperty("sqlReplaceModelSwitch"))) {
                sqlReplaceModelSwitch = Boolean.valueOf(properties.getProperty("sqlReplaceModelSwitch"));
            }
            JmqConfig.initConfig(properties);
            if (sqlReplaceModelSwitch != null && sqlReplaceModelSwitch.booleanValue() && StringUtils.isNotBlank((CharSequence)properties.getProperty("duccAppName")) && StringUtils.isNotBlank((CharSequence)properties.getProperty("duccUri")) && StringUtils.isNotBlank((CharSequence)properties.getProperty("duccMonitorKey"))) {
                DuccMonitorUtil.start(properties.getProperty("duccAppName"), properties.getProperty("duccUri"), properties.getProperty("duccMonitorKey"));
            }
        }
        catch (Exception e) {
            logger.error("sql analysis config init error", (Throwable)e);
        }
    }

    public static Boolean getAnalysisSwitch() {
        return analysisSwitch;
    }

    public static void setAnalysisSwitch(Boolean analysisSwitch) {
        SqlAnalysisConfig.analysisSwitch = analysisSwitch;
    }

    public static Boolean getOnlyCheckOnce() {
        return onlyCheckOnce;
    }

    public static void setOnlyCheckOnce(Boolean onlyCheckOnce) {
        SqlAnalysisConfig.onlyCheckOnce = onlyCheckOnce;
    }

    public static Long getCheckInterval() {
        return checkInterval;
    }

    public static void setCheckInterval(Long checkInterval) {
        SqlAnalysisConfig.checkInterval = checkInterval;
    }

    public static List<String> getExceptSqlIds() {
        return exceptSqlIds;
    }

    public static void setExceptSqlIds(List<String> exceptSqlIds) {
        SqlAnalysisConfig.exceptSqlIds = exceptSqlIds;
    }

    public static List<String> getSqlType() {
        return sqlType;
    }

    public static void setSqlType(List<String> sqlType) {
        SqlAnalysisConfig.sqlType = sqlType;
    }

    public static String getScoreRuleLoadClass() {
        return scoreRuleLoadClass;
    }

    public static String getOutputClass() {
        return outputClass;
    }

    public static List<SqlScoreRule> getRuleList() {
        return ruleList;
    }

    public static void setRuleList(List<SqlScoreRule> ruleList) {
        SqlAnalysisConfig.ruleList = ruleList;
    }

    public static String getOutputModel() {
        return outputModel;
    }

    public static void setOutputModel(String outputModel) {
        SqlAnalysisConfig.outputModel = outputModel;
    }

    public static String getAppName() {
        return appName;
    }

    public static void setAppName(String appName) {
        SqlAnalysisConfig.appName = appName;
    }

    public static Boolean getSqlReplaceModelSwitch() {
        return sqlReplaceModelSwitch;
    }

    public static void setSqlReplaceModelSwitch(Boolean sqlReplaceModelSwitch) {
        SqlAnalysisConfig.sqlReplaceModelSwitch = sqlReplaceModelSwitch;
    }

    static {
        ruleList = new ArrayList<SqlScoreRule>();
    }
}

