/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sqlanalysis.core;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis.SqlAnalysis;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis.SqlAnalysisResultList;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.config.JmqConfig;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.config.SqlAnalysisConfig;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.export.OutModelEnum;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.export.SqlScoreResultOutMq;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.export.SqlScoreResultOutService;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.export.SqlScoreResultOutServiceDefault;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.extract.SqlExtract;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.extract.SqlExtractResult;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.replace.SqlReplace;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.replace.SqlReplaceConfig;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.rule.SqlScoreRuleLoader;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.rule.SqlScoreRuleLoaderRulesEngine;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score.SqlScoreResult;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score.SqlScoreService;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score.SqlScoreServiceRulesEngine;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.GsonUtil;
import java.sql.Connection;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class SqlAnalysisAspect
implements Interceptor {
    Logger logger = LoggerFactory.getLogger(SqlAnalysisAspect.class);
    private static SqlScoreService sqlScoreService = new SqlScoreServiceRulesEngine();
    private static SqlScoreResultOutService sqlScoreResultOut = new SqlScoreResultOutServiceDefault();

    public Object intercept(Invocation invocation) throws Throwable {
        try {
            StatementHandler statementHandler;
            SqlExtractResult sqlExtractResult;
            Object firstArg = invocation.getArgs()[0];
            if (SqlAnalysisConfig.getSqlReplaceModelSwitch() != null && SqlAnalysisConfig.getSqlReplaceModelSwitch().booleanValue() && firstArg instanceof MappedStatement) {
                MappedStatement mappedStatement = (MappedStatement)firstArg;
                String replaceSql = SqlReplaceConfig.getReplaceSqlBySqlId(mappedStatement.getId());
                if (StringUtils.isNotBlank((CharSequence)replaceSql)) {
                    SqlReplace.replace(invocation, replaceSql);
                }
            } else if (SqlAnalysisConfig.getAnalysisSwitch().booleanValue() && firstArg instanceof Connection && (sqlExtractResult = SqlExtract.extract(statementHandler = (StatementHandler)invocation.getTarget())) != null) {
                Connection connection = (Connection)invocation.getArgs()[0];
                SqlAnalysisResultList resultList = SqlAnalysis.analysis(sqlExtractResult, connection);
                SqlScoreResult sqlScoreResult = sqlScoreService.score(resultList);
                if (sqlScoreResult != null) {
                    sqlScoreResult.setSqlId(sqlExtractResult.getSqlId());
                    sqlScoreResult.setSourceSql(sqlExtractResult.getSourceSql());
                    sqlScoreResultOut.outResult(sqlScoreResult);
                } else {
                    this.logger.error("sql analysis score error {},{}", (Object)GsonUtil.bean2Json(resultList), (Object)GsonUtil.bean2Json(sqlExtractResult));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("sql analysis error ", (Throwable)e);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        boolean loadScoreRuleRes;
        SqlAnalysisConfig.init(properties);
        SqlScoreRuleLoader sqlScoreRuleLoader = new SqlScoreRuleLoaderRulesEngine();
        if (StringUtils.isNotBlank((CharSequence)SqlAnalysisConfig.getScoreRuleLoadClass())) {
            try {
                sqlScoreRuleLoader = (SqlScoreRuleLoader)Class.forName(SqlAnalysisConfig.getScoreRuleLoadClass()).newInstance();
            }
            catch (Exception e) {
                this.logger.error("sql analysis init score mode error", (Throwable)e);
            }
        }
        if (!(loadScoreRuleRes = sqlScoreRuleLoader.loadScoreRule())) {
            this.logger.error("sql analysis loadScoreRule exception");
        }
        if (StringUtils.isNotBlank((CharSequence)SqlAnalysisConfig.getOutputModel()) && SqlAnalysisConfig.getOutputModel().toUpperCase().equals(OutModelEnum.MQ.getModelType())) {
            try {
                boolean result = JmqConfig.initMqProducer();
                if (result) {
                    SqlScoreResultOutMq outServiceClass = new SqlScoreResultOutMq();
                    sqlScoreResultOut = outServiceClass;
                }
            }
            catch (Exception e) {
                LogUtils.error((Throwable)e);
                this.logger.error("sql analysis init mq out mode error", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)SqlAnalysisConfig.getOutputClass())) {
            try {
                SqlScoreResultOutService outServiceClass;
                sqlScoreResultOut = outServiceClass = (SqlScoreResultOutService)Class.forName(SqlAnalysisConfig.getOutputClass()).newInstance();
            }
            catch (Exception e) {
                LogUtils.error((Throwable)e);
                this.logger.error("sql analysis init out mode error", (Throwable)e);
            }
        }
    }
}

