/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sqlanalysis.extract;

import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.config.SqlAnalysisConfig;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.extract.SqlExtractResult;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.GsonUtil;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.MetaObjectUtil;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.executor.statement.PreparedStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlExtract {
    private static Logger logger = LoggerFactory.getLogger(SqlExtract.class);
    private static ConcurrentHashMap<String, Long> checkedIdMap = new ConcurrentHashMap();

    public static SqlExtractResult extract(StatementHandler statementHandler) {
        MetaObject delegateMetaObject = MetaObjectUtil.forObject(statementHandler);
        if (delegateMetaObject.getValue("delegate") == null) {
            logger.warn("sql analysis get delegate null error,{}", (Object)GsonUtil.bean2Json(statementHandler.getBoundSql()));
            return null;
        }
        Object object = delegateMetaObject.getValue("delegate");
        if (!(object instanceof PreparedStatementHandler)) {
            logger.info("sql analysis get delegate is not PreparedStatementHandler,{}", (Object)GsonUtil.bean2Json(statementHandler.getBoundSql()));
            return null;
        }
        PreparedStatementHandler preparedStatementHandler = (PreparedStatementHandler)object;
        MetaObject metaObject = MetaObjectUtil.forObject(preparedStatementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("mappedStatement");
        String sqlId = mappedStatement.getId();
        String sqlType = mappedStatement.getSqlCommandType().name();
        logger.debug("sql analysis sqlId ={},sqlType={} ", (Object)sqlId, (Object)sqlType);
        if (!SqlExtract.needAnalysis(sqlId, sqlType)) {
            return null;
        }
        checkedIdMap.put(sqlId, System.currentTimeMillis());
        Object parameterObject = statementHandler.getParameterHandler().getParameterObject();
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
        Configuration cOnfiguration = mappedStatement.getConfiguration();
        String sql = SqlExtract.getSql(cOnfiguration, boundSql);
        logger.info("sql analysis sql = " + sql);
        SqlExtractResult result = new SqlExtractResult();
        result.setSqlId(sqlId);
        result.setSourceSql(sql);
        return result;
    }

    private static boolean needAnalysis(String sqlId, String sqlType) {
        if (!SqlAnalysisConfig.getSqlType().contains(sqlType)) {
            return false;
        }
        if (SqlAnalysisConfig.getExceptSqlIds().contains(sqlId)) {
            return false;
        }
        if (SqlAnalysisConfig.getOnlyCheckOnce().booleanValue() && checkedIdMap.get(sqlId) != null) {
            return false;
        }
        return checkedIdMap.get(sqlId) == null || System.currentTimeMillis() - checkedIdMap.get(sqlId) >= SqlAnalysisConfig.getCheckInterval();
    }

    private static String getSql(Configuration configuration, BoundSql boundSql) {
        String sql = SqlExtract.showSql(configuration, boundSql);
        StringBuilder str = new StringBuilder(100);
        str.append(sql);
        return str.toString();
    }

    private static String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (CollectionUtils.isNotEmpty((Collection)parameterMappings) && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(SqlExtract.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(SqlExtract.getParameterValue(obj)));
                        continue;
                    }
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(SqlExtract.getParameterValue(obj)));
                        continue;
                    }
                    sql = sql.replaceFirst("\\?", "\u7f3a\u5931");
                }
            }
        }
        return sql;
    }

    private static String getParameterValue(Object obj) {
        Object value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof java.util.Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(obj) + "'";
        } else {
            value = obj instanceof LocalDateTime ? "'" + String.valueOf(Timestamp.valueOf((LocalDateTime)obj)) + "'" : (obj instanceof LocalDate ? "'" + String.valueOf(Date.valueOf((LocalDate)obj)) + "'" : (obj instanceof LocalTime ? "'" + String.valueOf(Time.valueOf((LocalTime)obj)) + "'" : (obj != null ? obj.toString() : "")));
        }
        return value;
    }
}

