/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sqlanalysis.replace;

import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.DuccMonitorUtil;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.GsonUtil;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlReplaceConfig {
    static Logger log = LoggerFactory.getLogger(SqlReplaceConfig.class);
    private static HashMap<String, String> sqlReplaceMap = new HashMap();

    public static void initConfig() {
        try {
            String configStr = DuccMonitorUtil.getDuccConfig();
            if (StringUtils.isNotBlank((CharSequence)configStr)) {
                sqlReplaceMap = GsonUtil.json2Bean(configStr, HashMap.class);
            }
        }
        catch (Exception e) {
            log.error("sql analysis replace config init error :", (Throwable)e);
        }
    }

    public static String getReplaceSqlBySqlId(String sqlId) {
        if (StringUtils.isNotBlank((CharSequence)sqlId) && Objects.nonNull(sqlReplaceMap)) {
            return sqlReplaceMap.get(sqlId);
        }
        return null;
    }

    public static HashMap<String, String> getSqlReplaceMap() {
        return sqlReplaceMap;
    }
}

