/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sqlanalysis.rule;

import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis.SqlAnalysisResult;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.rule.RuleFieldEnum;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score.SqlScoreResultDetail;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.api.RulesEngine;
import org.jeasy.rules.core.DefaultRulesEngine;
import org.jeasy.rules.mvel.MVELRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesEngineExecutor {
    private static Logger logger = LoggerFactory.getLogger(RulesEngineExecutor.class);
    public static final RulesEngine rulesEngine = new DefaultRulesEngine();
    private static Rules rules;
    private static ConcurrentHashMap<String, SqlScoreResultDetail> scoreMap;

    public static boolean refresh() {
        Properties properties = new Properties();
        InputStream inputStream = RulesEngineExecutor.class.getClassLoader().getResourceAsStream("sql-analysis-rule-config.properties");
        try {
            properties.load(new InputStreamReader(inputStream));
            inputStream.close();
        }
        catch (IOException e) {
            logger.error("\u89c4\u5219\u5f15\u64ce\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
        }
        HashMap ruleMap = new HashMap();
        ConcurrentHashMap innerScoreMap = new ConcurrentHashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String[] keyArr = StringUtils.split((String)key.toString(), (char)'.');
            if (keyArr.length >= 2) {
                MVELRule rule = ruleMap.getOrDefault(keyArr[0], new MVELRule().name(keyArr[0]).then("ret.add(\"" + keyArr[0] + "\")"));
                SqlScoreResultDetail score = innerScoreMap.getOrDefault(keyArr[0], new SqlScoreResultDetail());
                switch (RuleFieldEnum.valueOf(keyArr[1].toUpperCase())) {
                    case CONDITION: {
                        rule.when(value.toString());
                        break;
                    }
                    case ACTION: {
                        rule.then(value.toString());
                        break;
                    }
                    case NAME: {
                        rule.name(value.toString());
                        break;
                    }
                    case DESCRIPTION: {
                        rule.description(value.toString());
                        break;
                    }
                    case PRIORITY: {
                        rule.priority(NumberUtils.toInt((String)value.toString()));
                        break;
                    }
                    case SCORE: {
                        score.setScoreDeduction(NumberUtils.toInt((String)value.toString()));
                        break;
                    }
                    case REASON: {
                        score.setReason(value.toString());
                        break;
                    }
                    case SUGGESTION: {
                        score.setSuggestion(value.toString());
                        break;
                    }
                    case STRICT: {
                        score.setStrict(Boolean.valueOf(value.toString()));
                    }
                }
                ruleMap.put(keyArr[0], rule);
                innerScoreMap.put(keyArr[0], score);
            }
        }));
        Rules newRules = new Rules(new Rule[0]);
        for (Map.Entry ruleEntry : ruleMap.entrySet()) {
            newRules.register(new Object[]{ruleEntry.getValue()});
        }
        rules = newRules;
        scoreMap = innerScoreMap;
        return true;
    }

    public static List<SqlScoreResultDetail> executeEngine(SqlAnalysisResult sqlAnalysisResult) {
        ArrayList<SqlScoreResultDetail> retList = new ArrayList<SqlScoreResultDetail>();
        ArrayList ret = new ArrayList();
        Facts facts = new Facts();
        facts.put("param", (Object)sqlAnalysisResult);
        facts.put("ret", ret);
        rulesEngine.fire(rules, facts);
        ret = (ArrayList)facts.get("ret");
        for (String item : ret) {
            if (scoreMap.get(item) == null) continue;
            retList.add(scoreMap.get(item));
        }
        return retList;
    }
}

