/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis.SqlAnalysisResult;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis.SqlAnalysisResultList;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.config.SqlAnalysisConfig;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.rule.SqlScoreRule;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score.SqlScoreResult;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score.SqlScoreResultDetail;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score.SqlScoreService;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.GsonUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SqlScoreServiceDefault
implements SqlScoreService {
    private static Logger logger = LoggerFactory.getLogger(SqlScoreServiceDefault.class);
    private static final Integer WARN_SCORE = 80;

    @Override
    public SqlScoreResult score(SqlAnalysisResultList sqlAnalysisResultList) {
        if (sqlAnalysisResultList == null || CollectionUtils.isEmpty(sqlAnalysisResultList.getResultList())) {
            return null;
        }
        Integer score = 100;
        SqlScoreResult scoreResult = new SqlScoreResult();
        ArrayList<SqlScoreResultDetail> analysisResults = new ArrayList<SqlScoreResultDetail>();
        for (SqlAnalysisResult result : sqlAnalysisResultList.getResultList()) {
            List<SqlScoreResultDetail> detail = this.matchRule(result);
            if (!CollectionUtils.isNotEmpty(detail)) continue;
            analysisResults.addAll(detail);
        }
        for (SqlScoreResultDetail detail : analysisResults) {
            if ((score = Integer.valueOf(score - detail.getScoreDeduction())) < 0) {
                score = 0;
            }
            if (score < WARN_SCORE) {
                scoreResult.setNeedWarn(true);
                continue;
            }
            scoreResult.setNeedWarn(false);
        }
        scoreResult.setScore(score);
        scoreResult.setAnalysisResults(analysisResults);
        logger.info("sql analysis result = " + GsonUtil.bean2Json(scoreResult));
        return scoreResult;
    }

    private List<SqlScoreResultDetail> matchRule(SqlAnalysisResult result) {
        ArrayList<SqlScoreResultDetail> detailList = new ArrayList<SqlScoreResultDetail>();
        if (CollectionUtils.isEmpty(SqlAnalysisConfig.getRuleList())) {
            return null;
        }
        for (SqlScoreRule sqlScoreRule : SqlAnalysisConfig.getRuleList()) {
            try {
                boolean matchResult;
                SqlScoreResultDetail detail = new SqlScoreResultDetail();
                String columnName = sqlScoreRule.getMatchColumn().getColumn();
                Object value = this.getValue(result, columnName);
                if (value == null || !(matchResult = this.matchColumn(sqlScoreRule, value))) continue;
                detail.setScoreDeduction(sqlScoreRule.getScoreDeduction());
                detail.setReason(sqlScoreRule.getReason());
                detail.setSuggestion(sqlScoreRule.getSuggestion());
                detail.setStrict(sqlScoreRule.getStrict());
                detailList.add(detail);
            }
            catch (Exception e) {
                LogUtils.error((Throwable)e);
                logger.error("sql analysis matchRule error:", (Throwable)e);
            }
        }
        return detailList;
    }

    private Object getValue(SqlAnalysisResult result, String columnName) {
        try {
            String methodName = "get" + columnName.substring(0, 1).toUpperCase() + columnName.substring(1);
            Class<SqlAnalysisResult> sqlAnalysisResultClass = SqlAnalysisResult.class;
            Method getMethod = sqlAnalysisResultClass.getDeclaredMethod(methodName, new Class[0]);
            Object value = getMethod.invoke((Object)result, new Object[0]);
            return value;
        }
        catch (Exception e) {
            logger.error("sql analysis get value error :", (Throwable)e);
            return null;
        }
    }

    private boolean matchColumn(SqlScoreRule sqlScoreRule, Object value) {
        boolean matchResult = false;
        switch (sqlScoreRule.getMatchType()) {
            case EQUAL: {
                if (!value.toString().equals(sqlScoreRule.getMatchValue())) break;
                matchResult = true;
                break;
            }
            case GREATER: {
                if (!(Double.parseDouble(value.toString()) > Double.parseDouble(sqlScoreRule.getMatchValue()))) break;
                matchResult = true;
                break;
            }
            case LESS: {
                if (!(Double.parseDouble(value.toString()) < Double.parseDouble(sqlScoreRule.getMatchValue()))) break;
                matchResult = true;
                break;
            }
            case CONTAIN: {
                if (!value.toString().contains(sqlScoreRule.getMatchValue())) break;
                matchResult = true;
                break;
            }
        }
        return matchResult;
    }
}

