/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score;

import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis.SqlAnalysisResult;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.analysis.SqlAnalysisResultList;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.rule.RulesEngineExecutor;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score.SqlScoreResult;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score.SqlScoreResultDetail;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.score.SqlScoreService;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.GsonUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlScoreServiceRulesEngine
implements SqlScoreService {
    private static Logger logger = LoggerFactory.getLogger(SqlScoreServiceRulesEngine.class);
    private static final Integer WARN_SCORE = 80;

    @Override
    public SqlScoreResult score(SqlAnalysisResultList sqlAnalysisResultList) {
        if (sqlAnalysisResultList == null || CollectionUtils.isEmpty(sqlAnalysisResultList.getResultList())) {
            return null;
        }
        int score = 100;
        SqlScoreResult scoreResult = new SqlScoreResult();
        ArrayList<SqlScoreResultDetail> analysisResults = new ArrayList<SqlScoreResultDetail>();
        for (SqlAnalysisResult result : sqlAnalysisResultList.getResultList()) {
            List<SqlScoreResultDetail> detail = this.matchRuleEngine(result);
            if (!CollectionUtils.isNotEmpty(detail)) continue;
            analysisResults.addAll(detail);
        }
        for (SqlScoreResultDetail detail : analysisResults) {
            if ((score -= detail.getScoreDeduction().intValue()) < 0) {
                score = 0;
            }
            if (score < WARN_SCORE) {
                scoreResult.setNeedWarn(true);
                continue;
            }
            scoreResult.setNeedWarn(false);
        }
        scoreResult.setScore(score);
        scoreResult.setAnalysisResults(analysisResults);
        logger.info("sql analysis result = " + GsonUtil.bean2Json(scoreResult));
        return scoreResult;
    }

    private List<SqlScoreResultDetail> matchRuleEngine(SqlAnalysisResult result) {
        return RulesEngineExecutor.executeEngine(result);
    }
}

