/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.config.JmqConfig;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.GsonUtil;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.util.KeyNodeLogModel;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyNodeLogUtil {
    private static Logger log = LoggerFactory.getLogger(KeyNodeLogUtil.class);
    private static RingBuffer<KeyNodeLogModel> ringBuffer = null;

    public static void initDisruptor() {
        int bufferSize = 1024;
        int batchLogSize = 10;
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "logDisruptorThread");
            }
        };
        EventFactory<KeyNodeLogModel> factory = new EventFactory<KeyNodeLogModel>(){

            public KeyNodeLogModel newInstance() {
                return new KeyNodeLogModel();
            }
        };
        BlockingWaitStrategy strategy = new BlockingWaitStrategy();
        Disruptor disruptor = new Disruptor((EventFactory)factory, bufferSize, threadFactory, ProducerType.SINGLE, (WaitStrategy)strategy);
        ringBuffer = disruptor.getRingBuffer();
        EventHandler<KeyNodeLogModel> handler = new EventHandler<KeyNodeLogModel>(){

            public void onEvent(KeyNodeLogModel element, long sequence, boolean endOfBatch) throws InterruptedException {
                if (Objects.isNull(element)) {
                    return;
                }
                KeyNodeLogUtil.sendSingleLog(element);
            }
        };
        disruptor.handleEventsWith(new EventHandler[]{handler});
        disruptor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyLogEvent(KeyNodeLogModel model) {
        long sequence;
        if (ringBuffer == null) {
            log.error("disruptor\u672a\u521d\u59cb\u5316\uff0c\u4f7f\u7528\u5355\u53d1mq");
            KeyNodeLogUtil.sendSingleLog(model);
            return;
        }
        try {
            sequence = ringBuffer.tryNext();
        }
        catch (InsufficientCapacityException e) {
            log.error("disruptor\u961f\u5217\u4e0d\u8db3\uff0c\u4f7f\u7528\u5355\u53d1mq");
            KeyNodeLogUtil.sendSingleLog(model);
            return;
        }
        try {
            KeyNodeLogModel event = (KeyNodeLogModel)ringBuffer.get(sequence);
            event.setBusinessId(model.getBusinessId());
            event.setBusinessTime(model.getBusinessTime());
            event.setDescribe(model.getDescribe());
            event.setLogTime(model.getLogTime());
            event.setModuleName(model.getModuleName());
            event.setNodeName(model.getNodeName());
        }
        catch (Exception e) {
            log.error("disruptor\u53d1\u5e03event\u5931\u8d25", (Throwable)e);
        }
        finally {
            ringBuffer.publish(sequence);
        }
    }

    public static void sendSingleLog(KeyNodeLogModel model) {
        String content = GsonUtil.bean2Json(model);
        try {
            KeyNodeLogUtil.sendMessage(JmqConfig.getTopic(), model.getBusinessId(), content);
        }
        catch (Exception e) {
            log.error("sql analysis out mq error" + model.getBusinessId(), (Throwable)e);
        }
    }

    public static void sendLog(String businessId, String modelName, String nodeName, String describe, Date businessTime) {
        KeyNodeLogModel model = KeyNodeLogModel.builder().businessId(businessId).businessTime(businessTime).logTime(new Date()).moduleName(modelName).nodeName(nodeName).describe(describe).build();
        if (!KeyNodeLogUtil.checkModel(model)) {
            return;
        }
        KeyNodeLogUtil.applyLogEvent(model);
    }

    public static boolean checkModel(KeyNodeLogModel model) {
        return !StringUtils.isBlank((CharSequence)model.getBusinessId()) && !StringUtils.isBlank((CharSequence)model.getModuleName()) && !StringUtils.isBlank((CharSequence)model.getNodeName());
    }

    public static void sendMessage(String topic, String businessId, String messageBody) {
    }

    public static synchronized void initProducer() {
    }

    static {
        KeyNodeLogUtil.initDisruptor();
    }
}

