/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.tenant;

import com.taotao.boot.data.mybatis.interceptor.tenant.handler.TenantInfoHandler;
import com.taotao.boot.data.mybatis.interceptor.tenant.parser.DefaultSqlParser;
import com.taotao.boot.data.mybatis.interceptor.tenant.service.ITenantService;
import java.util.Map;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class MybatisMultiTenantPluginInterceptor
implements Interceptor {
    private static final DefaultSqlParser DEFAULT_SQL_PARSER = new DefaultSqlParser();

    public MybatisMultiTenantPluginInterceptor(ITenantService tenantService, TenantInfoHandler tenantInfoHandler) {
        DEFAULT_SQL_PARSER.setTenantInfoHandler(tenantInfoHandler);
        DEFAULT_SQL_PARSER.setTenantService(tenantService);
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (DEFAULT_SQL_PARSER.isIgnoreDynamicDatasource()) {
            return invocation.proceed();
        }
        Object target = invocation.getTarget();
        if (target instanceof Executor) {
            MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
            Object param1 = invocation.getArgs()[1];
            BoundSql boundSql = ms.getBoundSql(param1);
            if (TenantInfoHandler.IGNORE_TENANT_ID_METHODS.contains(ms.getId())) {
                return invocation.proceed();
            }
            Object paramTenantId = this.getParamTenantId(param1);
            String sql = boundSql.getSql();
            sql = DEFAULT_SQL_PARSER.setTenantParameter(sql, paramTenantId);
            BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
            MappedStatement newMs = this.buildMappedStatement(ms, new BoundSqlSqlSource(newBoundSql));
            for (ParameterMapping mapping : boundSql.getParameterMappings()) {
                String prop = mapping.getProperty();
                if (!boundSql.hasAdditionalParameter(prop)) continue;
                newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
            }
            invocation.getArgs()[0] = newMs;
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor || target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    private MappedStatement buildMappedStatement(MappedStatement ms, SqlSource sqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), sqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private Object getParamTenantId(Object param1) {
        if (param1 instanceof Map) {
            TenantInfoHandler tenantInfoHandler = DEFAULT_SQL_PARSER.getTenantInfoHandler();
            String tenantIdColumn = tenantInfoHandler.getTenantIdColumn();
            Map paramMap = (Map)param1;
            return paramMap.getOrDefault(tenantIdColumn, null);
        }
        return null;
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

