/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.tenant.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLExprUtils;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.taotao.boot.data.mybatis.interceptor.tenant.handler.TenantInfoHandler;
import com.taotao.boot.data.mybatis.interceptor.tenant.parser.SqlParser;
import com.taotao.boot.data.mybatis.interceptor.tenant.service.ITenantService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DefaultSqlParser
implements SqlParser {
    private TenantInfoHandler tenantInfoHandler;
    private ITenantService tenantService;

    @Override
    public String setTenantParameter(String sql) {
        return this.setTenantParameter(sql, null);
    }

    @Override
    public String setTenantParameter(String sql, Object paramTenantId) {
        if (DefaultSqlParser.isEmpty(this.getTenantId(paramTenantId))) {
            return sql;
        }
        List statementList = SQLUtils.parseStatements((String)sql, (DbType)this.tenantInfoHandler.getDbType());
        StringBuilder stringBuilder = new StringBuilder();
        for (SQLStatement statement : statementList) {
            if (statement instanceof SQLSelectStatement) {
                SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)statement;
                this.processSelectBody(sqlSelectStatement.getSelect().getQuery(), paramTenantId);
            } else if (statement instanceof SQLInsertStatement) {
                this.processInsert((SQLInsertStatement)statement, paramTenantId);
            } else if (statement instanceof SQLUpdateStatement) {
                this.processUpdate((SQLUpdateStatement)statement, paramTenantId);
            } else if (statement instanceof SQLDeleteStatement) {
                this.processDelete((SQLDeleteStatement)statement, paramTenantId);
            }
            if (statementList.size() == 1) {
                return statement.toString();
            }
            stringBuilder.append(statement.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public void processSelectBody(SQLSelectQuery sqlSelectQuery, Object paramTenantId) {
        if (sqlSelectQuery instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock sqlSelectQueryBlock = (SQLSelectQueryBlock)sqlSelectQuery;
            List selectList = sqlSelectQueryBlock.getSelectList();
            selectList.forEach(sqlSelectItem -> {
                if (sqlSelectItem.getExpr() instanceof SQLQueryExpr) {
                    SQLQueryExpr expr = (SQLQueryExpr)sqlSelectItem.getExpr();
                    SQLSelectQuery query = expr.getSubQuery().getQuery();
                    this.processSelectBody(query, paramTenantId);
                } else if (sqlSelectItem.getExpr() instanceof SQLExistsExpr) {
                    SQLExistsExpr sqlExistsExpr = (SQLExistsExpr)sqlSelectItem.getExpr();
                    SQLSelectQuery query = sqlExistsExpr.getSubQuery().getQuery();
                    this.processSelectBody(query, paramTenantId);
                }
            });
            SQLTableSource table = sqlSelectQueryBlock.getFrom();
            if (table instanceof SQLExprTableSource) {
                SQLTableSource from = sqlSelectQueryBlock.getFrom();
                SQLExpr where = sqlSelectQueryBlock.getWhere();
                this.whereIn(where, paramTenantId);
                String alias = this.getAlias(from);
                String tableName = null;
                if (from instanceof SQLExprTableSource) {
                    SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)from;
                    tableName = sqlExprTableSource.getExpr().toString();
                }
                boolean isContainsTenantIdCondition = false;
                if (where instanceof SQLInListExpr) {
                    SQLInListExpr sqlExprTableSource = (SQLInListExpr)where;
                    isContainsTenantIdCondition = this.isContainsTenantIdCondition(sqlExprTableSource.getExpr());
                }
                if (!isContainsTenantIdCondition) {
                    SQLExpr newWhereCondition = this.createNewWhereCondition(tableName, where, alias, paramTenantId);
                    sqlSelectQueryBlock.setWhere(newWhereCondition);
                }
            } else if (table instanceof SQLJoinTableSource) {
                SQLJoinTableSource joinTableSource;
                SQLExprTableSource exprTableSource;
                SQLExpr tenantCondition;
                SQLJoinTableSource joinTable = (SQLJoinTableSource)table;
                SQLTableSource left = joinTable.getLeft();
                SQLTableSource right = joinTable.getRight();
                this.joinCondition(left, paramTenantId);
                this.joinCondition(right, paramTenantId);
                String tableName = null;
                if (right instanceof SQLExprTableSource) {
                    SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)right;
                    tableName = sqlExprTableSource.getExpr().toString();
                }
                if ((tenantCondition = this.getTenantCondition(tableName, right.getAlias(), joinTable.getCondition(), paramTenantId)) != null) {
                    joinTable.addCondition(tenantCondition);
                }
                SQLExpr condition = joinTable.getCondition();
                this.whereIn(condition, paramTenantId);
                String alias = this.getAlias(left);
                SQLExpr where = sqlSelectQueryBlock.getWhere();
                if (sqlSelectQueryBlock.getFrom() instanceof SQLExprTableSource) {
                    sqlExprTableSource = (SQLExprTableSource)sqlSelectQueryBlock.getFrom();
                    tableName = sqlExprTableSource.getExpr().toString();
                } else if (left instanceof SQLExprTableSource) {
                    sqlExprTableSource = (SQLExprTableSource)left;
                    tableName = sqlExprTableSource.getExpr().toString();
                } else if (left instanceof SQLJoinTableSource && (exprTableSource = this.lastJoinTableSourceLeadTable(joinTableSource = (SQLJoinTableSource)left)) != null) {
                    tableName = exprTableSource.getTableName();
                    alias = exprTableSource.getAlias();
                }
                SQLExpr newWhereCondition = this.createNewWhereCondition(tableName, where, alias, paramTenantId);
                sqlSelectQueryBlock.setWhere(newWhereCondition);
            } else if (table instanceof SQLSubqueryTableSource) {
                SQLSubqueryTableSource subQueryTable = (SQLSubqueryTableSource)table;
                SQLSelectQuery query = subQueryTable.getSelect().getQuery();
                this.processSelectBody(query, paramTenantId);
            } else if (table instanceof SQLUnionQueryTableSource) {
                SQLUnionQueryTableSource sqlUnionQueryTableSource = (SQLUnionQueryTableSource)table;
                SQLUnionQuery sqlUnionQuery = sqlUnionQueryTableSource.getUnion();
                this.unionQuery(sqlUnionQuery, paramTenantId);
            }
        } else if (sqlSelectQuery instanceof SQLUnionQuery) {
            SQLUnionQuery sqlUnionQuery = (SQLUnionQuery)sqlSelectQuery;
            this.unionQuery(sqlUnionQuery, paramTenantId);
        }
    }

    @Override
    public void processInsert(SQLInsertStatement insert, Object paramTenantId) {
        boolean isInsertFieldExistTenantIdColumn = false;
        String tenantIdColumn = this.tenantInfoHandler.getTenantIdColumn();
        List columns = insert.getColumns();
        for (SQLExpr column : columns) {
            if (this.isContainsTenantIdCondition(column)) {
                this.handlerInsertSelect(insert, tenantIdColumn, paramTenantId);
                return;
            }
            if (!column.toString().contains(tenantIdColumn)) continue;
            isInsertFieldExistTenantIdColumn = true;
        }
        String tableName = insert.getTableName().toString();
        if (this.ignoreTable(tableName)) {
            return;
        }
        List<Object> tenantIds = this.getTenantId(paramTenantId);
        if (tenantIds.size() == 0) {
            return;
        }
        if (!columns.isEmpty() && !isInsertFieldExistTenantIdColumn) {
            insert.addColumn((SQLExpr)new SQLIdentifierExpr(this.tenantInfoHandler.getTenantIdColumn()));
            Object tenantId = tenantIds.get(0);
            insert.getValuesList().forEach(valuesClause -> valuesClause.addValue(tenantId));
        }
        this.handlerInsertSelect(insert, tenantIdColumn, paramTenantId);
    }

    @Override
    public void processUpdate(SQLUpdateStatement update, Object paramTenantId) {
        SQLTableSource sqlTableSource = update.getTableSource();
        String alias = sqlTableSource.getAlias();
        String tableName = sqlTableSource.toString();
        if (sqlTableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinTableSource;
            SQLExprTableSource exprTableSource;
            SQLExpr tenantCondition;
            SQLJoinTableSource joinTable = (SQLJoinTableSource)sqlTableSource;
            SQLTableSource left = joinTable.getLeft();
            SQLTableSource right = joinTable.getRight();
            this.joinCondition(left, paramTenantId);
            this.joinCondition(right, paramTenantId);
            if (right instanceof SQLExprTableSource) {
                SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)right;
                tableName = sqlExprTableSource.getExpr().toString();
            }
            if ((tenantCondition = this.getTenantCondition(tableName, right.getAlias(), joinTable.getCondition(), paramTenantId)) != null) {
                joinTable.addCondition(tenantCondition);
            }
            SQLExpr condition = joinTable.getCondition();
            this.whereIn(condition, paramTenantId);
            alias = left instanceof SQLJoinTableSource ? ((SQLJoinTableSource)left).getLeft().getAlias() : left.getAlias();
            if (left instanceof SQLExprTableSource) {
                tableName = ((SQLExprTableSource)left).getExpr().toString();
            } else if (left instanceof SQLJoinTableSource && (exprTableSource = this.lastJoinTableSourceLeadTable(joinTableSource = (SQLJoinTableSource)left)) != null) {
                tableName = exprTableSource.getTableName();
                alias = exprTableSource.getAlias();
            }
        } else if (sqlTableSource instanceof SQLExprTableSource) {
            tableName = ((SQLExprTableSource)sqlTableSource).getExpr().toString();
        }
        SQLExpr tenantCondition = this.getTenantCondition(tableName, alias, update.getWhere(), paramTenantId);
        if (tenantCondition != null) {
            update.addCondition(tenantCondition);
        }
        SQLExpr where = update.getWhere();
        this.whereIn(where, paramTenantId);
    }

    @Override
    public void processDelete(SQLDeleteStatement delete, Object paramTenantId) {
        SQLTableSource tableSource = delete.getTableSource();
        String alias = tableSource.getAlias();
        String tableName = null;
        if (tableSource instanceof SQLJoinTableSource || delete.getFrom() instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinTableSource;
            SQLExprTableSource exprTableSource;
            SQLExpr tenantCondition;
            SQLJoinTableSource joinTable = tableSource instanceof SQLJoinTableSource ? (SQLJoinTableSource)tableSource : (SQLJoinTableSource)delete.getFrom();
            SQLTableSource left = joinTable.getLeft();
            SQLTableSource right = joinTable.getRight();
            this.joinCondition(left, paramTenantId);
            this.joinCondition(right, paramTenantId);
            if (right instanceof SQLExprTableSource) {
                SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)right;
                tableName = sqlExprTableSource.getExpr().toString();
            }
            if ((tenantCondition = this.getTenantCondition(tableName, right.getAlias(), joinTable.getCondition(), paramTenantId)) != null) {
                joinTable.addCondition(tenantCondition);
            }
            SQLExpr condition = joinTable.getCondition();
            this.whereIn(condition, paramTenantId);
            alias = left instanceof SQLJoinTableSource ? ((SQLJoinTableSource)left).getLeft().getAlias() : left.getAlias();
            if (left instanceof SQLExprTableSource) {
                tableName = ((SQLExprTableSource)left).getExpr().toString();
            } else if (left instanceof SQLJoinTableSource && (exprTableSource = this.lastJoinTableSourceLeadTable(joinTableSource = (SQLJoinTableSource)left)) != null) {
                tableName = exprTableSource.getTableName();
                alias = exprTableSource.getAlias();
            }
        } else if (tableSource instanceof SQLExprTableSource) {
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)tableSource;
            tableName = sqlExprTableSource.getExpr().toString();
        }
        SQLExpr tenantCondition = this.getTenantCondition(tableName, alias, delete.getWhere(), paramTenantId);
        if (tenantCondition != null) {
            delete.addCondition(tenantCondition);
        }
        SQLExpr where = delete.getWhere();
        this.whereIn(where, paramTenantId);
    }

    private void joinCondition(SQLTableSource sqlTableSource, Object paramTenantId) {
        if (sqlTableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)sqlTableSource;
            SQLTableSource left = sqlJoinTableSource.getLeft();
            SQLTableSource right = sqlJoinTableSource.getRight();
            String tableName = null;
            if (right instanceof SQLExprTableSource) {
                sqlExprTableSource = (SQLExprTableSource)right;
                tableName = sqlExprTableSource.getExpr().toString();
            } else if (left instanceof SQLExprTableSource) {
                sqlExprTableSource = (SQLExprTableSource)left;
                tableName = sqlExprTableSource.getExpr().toString();
            }
            SQLExpr tenantCondition = this.getTenantCondition(tableName, sqlJoinTableSource.getRight().getAlias(), sqlJoinTableSource.getCondition(), paramTenantId);
            if (tenantCondition != null) {
                sqlJoinTableSource.addCondition(tenantCondition);
            }
            this.joinCondition(left, paramTenantId);
            this.joinCondition(right, paramTenantId);
        } else if (sqlTableSource instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource subQueryTable = (SQLSubqueryTableSource)sqlTableSource;
            SQLSelectQuery query = subQueryTable.getSelect().getQuery();
            this.processSelectBody(query, paramTenantId);
        } else if (sqlTableSource instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource sqlUnionQueryTableSource = (SQLUnionQueryTableSource)sqlTableSource;
            SQLUnionQuery sqlUnionQuery = sqlUnionQueryTableSource.getUnion();
            this.unionQuery(sqlUnionQuery, paramTenantId);
        }
    }

    private SQLExpr createNewWhereCondition(String tableName, SQLExpr where, String alias, Object paramTenantId) {
        if (where != null) {
            SQLExpr tenantCondition;
            if (where instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr sqlExpr = (SQLBinaryOpExpr)where;
                SQLExpr right = sqlExpr.getRight();
                this.whereIn(right, paramTenantId);
            }
            if ((tenantCondition = this.getTenantCondition(tableName, alias, where, paramTenantId)) == null) {
                return where;
            }
            SQLBinaryOpExpr sqlBinaryOpExpr = new SQLBinaryOpExpr();
            sqlBinaryOpExpr.setOperator(SQLBinaryOperator.BooleanAnd);
            sqlBinaryOpExpr.setParent(where.getParent());
            sqlBinaryOpExpr.setLeft(where);
            sqlBinaryOpExpr.setRight(tenantCondition);
            return sqlBinaryOpExpr;
        }
        return this.getTenantCondition(tableName, alias, where, paramTenantId);
    }

    private void whereIn(SQLExpr sqlExpr, Object paramTenantId) {
        if (sqlExpr instanceof SQLInSubQueryExpr) {
            SQLSelect subQuery = ((SQLInSubQueryExpr)sqlExpr).getSubQuery();
            SQLSelectQueryBlock selectQueryBlock = subQuery.getQueryBlock();
            if (selectQueryBlock != null) {
                this.processSelectBody((SQLSelectQuery)selectQueryBlock, paramTenantId);
            } else {
                SQLSelectQuery query = subQuery.getQuery();
                if (query instanceof SQLUnionQuery) {
                    SQLUnionQuery sqlUnionQuery = (SQLUnionQuery)query;
                    this.unionQuery(sqlUnionQuery, paramTenantId);
                }
            }
        } else if (sqlExpr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr sqlBinaryOpExpr = (SQLBinaryOpExpr)sqlExpr;
            this.whereIn(sqlBinaryOpExpr.getLeft(), paramTenantId);
            this.whereIn(sqlBinaryOpExpr.getRight(), paramTenantId);
        }
    }

    private SQLExpr getTenantCondition(String tableName, String alias, SQLExpr condition, Object paramTenantId) {
        if (this.isContainsTenantIdCondition(condition) || this.ignoreTable(tableName) || this.ignoreTableAlias(alias)) {
            return null;
        }
        List<Object> tenantIds = this.getTenantId(paramTenantId);
        if (tenantIds.size() == 1) {
            return this.conditionEquality(alias, tenantIds.get(0));
        }
        if (tenantIds.size() > 1) {
            return this.conditionIn(alias, tenantIds);
        }
        return null;
    }

    private List<Object> getTenantId(Object paramTenantId) {
        List<Object> tenantIds = null;
        if (paramTenantId != null) {
            tenantIds = new ArrayList<Object>();
            if (paramTenantId instanceof List) {
                tenantIds.addAll((List)paramTenantId);
            } else if (paramTenantId instanceof Set) {
                tenantIds.addAll((Set)paramTenantId);
            } else {
                tenantIds.add(paramTenantId);
            }
        }
        if (tenantIds == null && (tenantIds = this.tenantInfoHandler.getTenantIds()) == null) {
            tenantIds = new ArrayList();
        }
        return tenantIds;
    }

    private SQLBinaryOpExpr conditionEquality(String alias, Object tenantId) {
        SQLBinaryOpExpr tenantIdWhere = new SQLBinaryOpExpr();
        SQLPropertyExpr leftExpr = new SQLPropertyExpr();
        String tenantIdColumn = this.tenantInfoHandler.getTenantIdColumn();
        SQLExpr expr = SQLExprUtils.fromJavaObject((Object)tenantId, null);
        if (alias != null) {
            leftExpr.setOwner(alias);
            leftExpr.setName(tenantIdColumn);
            tenantIdWhere.setLeft((SQLExpr)leftExpr);
            tenantIdWhere.setRight(expr);
            tenantIdWhere.setOperator(SQLBinaryOperator.Equality);
        } else {
            tenantIdWhere.setOperator(SQLBinaryOperator.Equality);
            tenantIdWhere.setLeft((SQLExpr)new SQLIdentifierExpr(tenantIdColumn));
            tenantIdWhere.setRight(expr);
        }
        return tenantIdWhere;
    }

    private SQLInListExpr conditionIn(String alias, List<Object> tenantIds) {
        if (alias != null) {
            SQLIdentifierExpr sqlIdentifierExpr = new SQLIdentifierExpr(alias);
            SQLPropertyExpr sqlPropertyExpr = new SQLPropertyExpr((SQLExpr)sqlIdentifierExpr, this.tenantInfoHandler.getTenantIdColumn());
            sqlIdentifierExpr.setParent((SQLObject)sqlPropertyExpr);
            SQLInListExpr sqlInListExpr = new SQLInListExpr((SQLExpr)sqlPropertyExpr);
            for (Object value : tenantIds) {
                sqlInListExpr.addTarget(SQLExprUtils.fromJavaObject((Object)value, null));
            }
            return sqlInListExpr;
        }
        return SQLExprUtils.conditionIn((String)this.tenantInfoHandler.getTenantIdColumn(), tenantIds, null);
    }

    private boolean isContainsTenantIdCondition(SQLExpr where) {
        if (!(where instanceof SQLBinaryOpExpr)) {
            if (where instanceof SQLPropertyExpr || where instanceof SQLIdentifierExpr) {
                return String.valueOf(where).contains(this.tenantInfoHandler.getTenantIdColumn());
            }
            return false;
        }
        SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)where;
        SQLExpr left = binaryOpExpr.getLeft();
        SQLExpr right = binaryOpExpr.getRight();
        boolean isContainsTenantIdCondition = false;
        if (left instanceof SQLBinaryOpExpr || left instanceof SQLPropertyExpr) {
            isContainsTenantIdCondition = String.valueOf(left).contains(this.tenantInfoHandler.getTenantIdColumn());
        }
        if (right instanceof SQLBinaryOpExpr) {
            isContainsTenantIdCondition = String.valueOf(right).contains(this.tenantInfoHandler.getTenantIdColumn());
        }
        if (left instanceof SQLIdentifierExpr) {
            isContainsTenantIdCondition = String.valueOf(left).equals(this.tenantInfoHandler.getTenantIdColumn());
        }
        if (right instanceof SQLIdentifierExpr) {
            isContainsTenantIdCondition = String.valueOf(right).equals(this.tenantInfoHandler.getTenantIdColumn());
        }
        return isContainsTenantIdCondition;
    }

    private void unionQuery(SQLUnionQuery sqlUnionQuery, Object paramTenantId) {
        sqlUnionQuery.getRelations().forEach(sqlSelectQuery -> this.processSelectBody((SQLSelectQuery)sqlSelectQuery, paramTenantId));
    }

    private void handlerInsertSelect(SQLInsertStatement insert, String tenantIdColumn, Object paramTenantId) {
        SQLSelect query = insert.getQuery();
        if (query != null) {
            SQLSelectQuery sqlSelectQuery = query.getQuery();
            this.processSelectBody(sqlSelectQuery, paramTenantId);
            if (sqlSelectQuery instanceof SQLSelectQueryBlock) {
                SQLSelectItem selectItem;
                SQLSelectQueryBlock block = (SQLSelectQueryBlock)sqlSelectQuery;
                boolean isExistTenantIdColumn = false;
                for (SQLSelectItem sqlSelectItem : block.getSelectList()) {
                    String expr = sqlSelectItem.getExpr().toString();
                    if (!expr.contains(tenantIdColumn) && !"*".equals(expr)) continue;
                    isExistTenantIdColumn = true;
                    break;
                }
                if (!isExistTenantIdColumn && (selectItem = block.findSelectItem(tenantIdColumn)) == null) {
                    block.addSelectItem(tenantIdColumn, null);
                }
            }
        }
    }

    private SQLExprTableSource lastJoinTableSourceLeadTable(SQLJoinTableSource joinTableSource) {
        SQLExprTableSource sqlExprTableSource = null;
        while (true) {
            if (joinTableSource.getLeft() instanceof SQLExprTableSource) {
                sqlExprTableSource = (SQLExprTableSource)joinTableSource.getLeft();
                break;
            }
            if (!(joinTableSource.getLeft() instanceof SQLJoinTableSource)) break;
            joinTableSource = (SQLJoinTableSource)joinTableSource.getLeft();
        }
        return sqlExprTableSource;
    }

    private boolean ignoreTable(String tableName) {
        if (tableName == null) {
            return false;
        }
        tableName = tableName.replace("`", "");
        List<String> ignoreTableNames = this.tenantInfoHandler.ignoreTableName();
        boolean ignoreTable = this.ignoreTableNamePrefix(tableName);
        if (ignoreTable) {
            return ignoreTable;
        }
        if (DefaultSqlParser.isEmpty(ignoreTableNames)) {
            return false;
        }
        for (String ignoreTableName : ignoreTableNames) {
            if (!tableName.equals(ignoreTableName)) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreTableNamePrefix(String tableName) {
        List<String> ignoreTableNamePrefix = this.tenantInfoHandler.ignoreTableNamePrefix();
        if (DefaultSqlParser.isEmpty(ignoreTableNamePrefix)) {
            return false;
        }
        for (String tableNamePrefix : ignoreTableNamePrefix) {
            if (tableName.indexOf(tableNamePrefix) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreTableAlias(String tableAlias) {
        if (tableAlias == null) {
            return false;
        }
        List<String> ignoreMatchTableAlias = this.tenantInfoHandler.ignoreMatchTableAlias();
        if (DefaultSqlParser.isEmpty(ignoreMatchTableAlias)) {
            return false;
        }
        return ignoreMatchTableAlias.stream().anyMatch(tableAlias::equals);
    }

    private String getAlias(SQLTableSource sqlTableSource) {
        if (sqlTableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)sqlTableSource;
            if (sqlJoinTableSource.getLeft() instanceof SQLJoinTableSource) {
                return this.getAlias(sqlJoinTableSource.getLeft());
            }
            if (sqlJoinTableSource.getLeft() instanceof SQLExprTableSource) {
                SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)sqlJoinTableSource.getLeft();
                return sqlExprTableSource.getAlias();
            }
            if (sqlJoinTableSource.getLeft() instanceof SQLSubqueryTableSource) {
                SQLSubqueryTableSource sqlSubqueryTableSource = (SQLSubqueryTableSource)sqlJoinTableSource.getLeft();
                return sqlSubqueryTableSource.getAlias();
            }
            return sqlJoinTableSource.getAlias();
        }
        if (sqlTableSource instanceof SQLExprTableSource) {
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)sqlTableSource;
            return sqlExprTableSource.getAlias();
        }
        if (sqlTableSource != null) {
            return sqlTableSource.getAlias();
        }
        return null;
    }

    public void setTenantInfoHandler(TenantInfoHandler tenantInfoHandler) {
        this.tenantInfoHandler = tenantInfoHandler;
    }

    public TenantInfoHandler getTenantInfoHandler() {
        return this.tenantInfoHandler;
    }

    public void setTenantService(ITenantService tenantService) {
        this.tenantService = tenantService;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public boolean isIgnoreDynamicDatasource() {
        String ignoreDynamicDatasource = this.tenantService.ignoreDynamicDatasource();
        List<String> ignoreDynamicDatasourceList = this.tenantInfoHandler.ignoreDynamicDatasource();
        if (ignoreDynamicDatasource == null || ignoreDynamicDatasource.length() == 0 || DefaultSqlParser.isEmpty(ignoreDynamicDatasourceList)) {
            return false;
        }
        return ignoreDynamicDatasourceList.stream().anyMatch(ignoreDynamicDatasource::equals);
    }
}

