/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.tenant.starter;

import com.taotao.boot.data.mybatis.interceptor.tenant.annotation.IgnoreTenantIdField;
import com.taotao.boot.data.mybatis.interceptor.tenant.handler.TenantInfoHandler;
import java.lang.reflect.Method;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class MyBeanPostProcessor
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MapperFactoryBean) {
            Method[] methods;
            MapperFactoryBean mapperFactoryBean = (MapperFactoryBean)bean;
            String mapperName = mapperFactoryBean.getObjectType().getName();
            for (Method item : methods = mapperFactoryBean.getObjectType().getMethods()) {
                IgnoreTenantIdField annotation = item.getAnnotation(IgnoreTenantIdField.class);
                if (annotation == null) continue;
                TenantInfoHandler.IGNORE_TENANT_ID_METHODS.add(String.format("%s.%s", mapperName, item.getName()));
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

