/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.tenant.starter;

import com.alibaba.druid.DbType;
import com.taotao.boot.data.mybatis.interceptor.tenant.MybatisMultiTenantPluginInterceptor;
import com.taotao.boot.data.mybatis.interceptor.tenant.handler.TenantInfoHandler;
import com.taotao.boot.data.mybatis.interceptor.tenant.service.ITenantService;
import com.taotao.boot.data.mybatis.interceptor.tenant.starter.TenantProperties;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

public class StartSysListener
implements ApplicationListener<ApplicationStartedEvent> {
    private static Logger log = LoggerFactory.getLogger(StartSysListener.class);
    private final List<SqlSessionFactory> sqlSessionFactoryList;
    private final ITenantService tenantService;
    private final TenantProperties tenantProperties;

    public StartSysListener(ITenantService tenantService, TenantProperties tenantProperties, List<SqlSessionFactory> sqlSessionFactoryList) {
        this.tenantService = tenantService;
        this.tenantProperties = tenantProperties;
        this.sqlSessionFactoryList = sqlSessionFactoryList;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        log.debug("\u6dfb\u52a0\u81ea\u5b9a\u4e49Mybatis\u591a\u79df\u6237SQL\u62e6\u622a\u5668");
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)new MybatisMultiTenantPluginInterceptor(this.tenantService, new TenantInfoHandler(){

                public List getTenantIds() {
                    return StartSysListener.this.tenantService.getTenantIds();
                }

                @Override
                public List<String> ignoreTableName() {
                    return StartSysListener.this.tenantProperties.getIgnoreTableName();
                }

                @Override
                public List<String> ignoreMatchTableAlias() {
                    return StartSysListener.this.tenantProperties.getIgnoreMatchTableAlias();
                }

                @Override
                public List<String> ignoreTableNamePrefix() {
                    return StartSysListener.this.tenantProperties.getIgnoreTableNamePrefix();
                }

                @Override
                public String getTenantIdColumn() {
                    return StartSysListener.this.tenantProperties.getTenantIdColumn();
                }

                @Override
                public List<String> ignoreDynamicDatasource() {
                    return StartSysListener.this.tenantProperties.getIgnoreDynamicDatasource();
                }

                @Override
                public DbType getDbType() {
                    return StartSysListener.this.tenantProperties.getDbType();
                }
            }));
        }
    }
}

