/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.javers;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.javers.CustomerLabel;
import com.taotao.boot.data.mybatis.javers.CustomerTypeEnum;
import com.taotao.boot.data.mybatis.javers.Dealer;
import com.taotao.boot.data.mybatis.javers.annotation.Column;
import com.taotao.boot.data.mybatis.javers.comparator.CustomerLabelComparator;
import com.taotao.boot.data.mybatis.javers.comparator.CustomerTypeComparator;
import com.taotao.boot.data.mybatis.javers.comparator.DealerComparator;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dromara.hutool.core.collection.CollUtil;
import org.javers.core.Changes;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.diff.custom.CustomValueComparator;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class JaversUtil<T> {
    private static final Javers JAVERS = JaversBuilder.javers().registerValue(CustomerLabel.class, (CustomValueComparator)new CustomerLabelComparator()).registerValue(Dealer.class, (CustomValueComparator)new DealerComparator()).registerValue(CustomerTypeEnum.class, (CustomValueComparator)new CustomerTypeComparator()).build();

    public static <T> Changes diff(@NonNull T before, @NonNull T after) {
        Diff compare = JAVERS.compare(before, after);
        Changes changes = compare.getChanges();
        if (CollUtil.isNotEmpty((Collection)changes)) {
            for (Change change : changes) {
                Optional affectedObject = change.getAffectedObject();
                if (!affectedObject.isPresent()) continue;
                if (change instanceof NewObject) {
                    NewObject newObj = (NewObject)change;
                    LogUtils.info((String)("\u65b0\u589e=>" + String.valueOf(newObj)), (Object[])new Object[0]);
                    continue;
                }
                if (change instanceof ObjectRemoved) {
                    ObjectRemoved objRemoved = (ObjectRemoved)change;
                    LogUtils.info((String)("\u5220\u9664=>" + String.valueOf(objRemoved)), (Object[])new Object[0]);
                    continue;
                }
                if (change instanceof ValueChange) {
                    ValueChange valueChange = (ValueChange)change;
                    String propertyName = valueChange.getPropertyName();
                    Field field = JaversUtil.getField(propertyName, change.getAffectedObject().get().getClass());
                    Assert.notNull((Object)field, (String)"");
                    Column annotation = field.getAnnotation(Column.class);
                    LogUtils.info((String)"type: {}", (Object[])new Object[]{field.getType()});
                    field.setAccessible(true);
                    LogUtils.info((String)(annotation.name() + ": " + JaversUtil.str(valueChange.getLeft()) + "\u4fee\u6539=> " + JaversUtil.str(valueChange.getRight())), (Object[])new Object[0]);
                    continue;
                }
                if (!(change instanceof ListChange)) continue;
                ListChange listChange = (ListChange)change;
                LogUtils.info((String)"left: {}", (Object[])new Object[]{listChange.getLeft()});
                LogUtils.info((String)"right: {}", (Object[])new Object[]{listChange.getRight()});
                LogUtils.info((String)("\u96c6\u5408\u53d8\u5316=>" + String.valueOf(listChange)), (Object[])new Object[0]);
            }
        }
        return null;
    }

    private static String str(Object obj) {
        if (obj instanceof CustomerTypeEnum) {
            return ((CustomerTypeEnum)((Object)obj)).getMsg();
        }
        if (obj instanceof Dealer) {
            return ((Dealer)obj).getDearName();
        }
        return null;
    }

    private static List<Field> getFields(Class clazz) {
        List<Field> annotationFieldList = Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class)).collect(Collectors.toList());
        if (CollUtil.isEmpty(annotationFieldList)) {
            return Collections.emptyList();
        }
        return annotationFieldList;
    }

    private static Field getField(String fieldName, Class clazz) {
        List<Field> fields = JaversUtil.getFields(clazz);
        if (CollUtil.isEmpty(fields)) {
            return null;
        }
        return fields.stream().filter(field -> fieldName.equals(field.getName())).findFirst().orElse(null);
    }

    public static <T> Changes diff(List<T> before, List<T> after, Class<T> clazz) {
        Diff diff = JAVERS.compareCollections(before, after, clazz);
        return diff.getChanges();
    }
}

