/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.l2cache;

import com.taotao.boot.cache.redis.repository.RedisRepository;
import com.taotao.boot.common.exception.BaseException;
import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.reflect.ClassUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisMybatisCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(RedisMybatisCache.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final String id;
    private final AtomicInteger counter = new AtomicInteger(0);
    private RedisRepository redisRepository;
    private static final long EXPIRE_TIME_MINUTES = 30L;

    public RedisMybatisCache(String id) {
        this.id = id;
        ClassUtils.notExistThrow(RedisRepository.class, (String)"\u8bf7\u6dfb\u52a0taotao-boot-starter-cache:taotao-boot-starter-cache-redis\u6a21\u5757");
        RedisRepository redisRepository = (RedisRepository)ContextUtils.getBean(RedisRepository.class, (boolean)true);
        if (Objects.isNull(redisRepository)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230");
        }
        this.redisRepository = redisRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedisRepository getRedisTemplate() {
        if (this.redisRepository == null) {
            Class<RedisMybatisCache> clazz = RedisMybatisCache.class;
            synchronized (RedisMybatisCache.class) {
                if (this.redisRepository == null) {
                    this.redisRepository = (RedisRepository)ContextUtils.getBean(RedisRepository.class, (boolean)true);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return this.redisRepository;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.redisRepository;
            }
        }
        return this.redisRepository;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object key, Object value) {
        this.redisRepository.hset(this.id, key.toString(), value);
        this.counter.incrementAndGet();
        log.debug("CACHE - Put data into Mybatis Cache, with key: [{}]", key);
    }

    public Object getObject(Object key) {
        Object obj = this.redisRepository.hget(this.id, key.toString());
        log.debug("CACHE - Get data from Mybatis Cache, with key: [{}]", key);
        return obj;
    }

    public Object removeObject(Object key) {
        Long obj = this.redisRepository.hDel(this.id, new Object[]{key.toString()});
        this.counter.decrementAndGet();
        log.debug("CACHE - Remove data from Mybatis Cache, with key: [{}]", key);
        return obj;
    }

    public void clear() {
        this.redisRepository.hDel(this.id, new Object[0]);
        log.debug("CACHE - Clear Mybatis Cache.");
    }

    public int getSize() {
        return this.redisRepository.hsize(this.id).intValue();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

