/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.UpdateChainWrapper;
import com.baomidou.mybatisplus.extension.kotlin.KtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.kotlin.KtUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.toolkit.ChainWrappers;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.taotao.boot.data.mybatis.mybatisplus.MpUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.SqlSession;
import org.dromara.hutool.core.collection.CollUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class BaseManager<M extends BaseMapper<T>, T> {
    protected int DEFAULT_BATCH_SIZE = 1000;
    protected Log log = LogFactory.getLog(this.getClass());
    @Autowired
    protected M baseMapper;

    public M getBaseMapper() {
        return this.baseMapper;
    }

    public Class<T> getEntityClass() {
        return this.currentModelClass();
    }

    protected Class<M> currentMapperClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), BaseManager.class, (int)0);
    }

    protected Class<T> currentModelClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), BaseManager.class, (int)1);
    }

    protected String getKeyProperty() {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        Assert.notNull((Object)tableInfo, (String)"\u9519\u8bef:\u65e0\u6cd5\u6267\u884c.\u56e0\u4e3a\u627e\u4e0d\u5230\u5b9e\u4f53\u7684 TableInfo \u7f13\u5b58!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"\u9519\u8bef:\u65e0\u6cd5\u6267\u884c.\u56e0\u4e3a\u65e0\u6cd5\u4ece\u5b9e\u4f53\u4e2d\u627e\u5230\u4e3b\u952e\u7684\u5217!", (Object[])new Object[0]);
        return keyProperty;
    }

    public QueryChainWrapper<T> query() {
        return ChainWrappers.queryChain(this.getBaseMapper());
    }

    public LambdaQueryChainWrapper<T> lambdaQuery() {
        return ChainWrappers.lambdaQueryChain(this.getBaseMapper());
    }

    public KtQueryChainWrapper<T> ktQuery() {
        return ChainWrappers.ktQueryChain(this.getBaseMapper(), this.getEntityClass());
    }

    public KtUpdateChainWrapper<T> ktUpdate() {
        return ChainWrappers.ktUpdateChain(this.getBaseMapper(), this.getEntityClass());
    }

    public UpdateChainWrapper<T> update() {
        return ChainWrappers.updateChain(this.getBaseMapper());
    }

    public LambdaUpdateChainWrapper<T> lambdaUpdate() {
        return ChainWrappers.lambdaUpdateChain(this.getBaseMapper());
    }

    protected String getSqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.getSqlStatement(this.currentMapperClass(), (SqlMethod)sqlMethod);
    }

    public T save(T t) {
        this.baseMapper.insert(t);
        return t;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<T> saveAll(List<T> list) {
        if (CollUtil.isNotEmpty(list)) {
            this.saveBatch(list, this.DEFAULT_BATCH_SIZE);
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.INSERT_ONE);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateAllById(Collection<T> entityList) {
        if (CollUtil.isNotEmpty(entityList)) {
            return this.updateBatchById(entityList, this.DEFAULT_BATCH_SIZE);
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.UPDATE_BY_ID);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
        });
    }

    protected <E> boolean executeBatch(Collection<E> list, int batchSize, BiConsumer<SqlSession, E> consumer) {
        return SqlHelper.executeBatch(this.currentModelClass(), (Log)this.log, list, (int)batchSize, consumer);
    }

    @Transactional(rollbackFor={Exception.class})
    public T saveOrUpdate(T entity) {
        if (null != entity) {
            String keyProperty = this.getKeyProperty();
            Object idVal = SystemMetaObject.forObject(entity).getValue(keyProperty);
            if (StringUtils.checkValNull((Object)idVal) || Objects.isNull(this.findById((Serializable)idVal))) {
                this.save(entity);
            } else {
                this.updateById(entity);
            }
        }
        return entity;
    }

    public T updateById(T t) {
        if (!SqlHelper.retBool((Integer)this.baseMapper.updateById(t))) {
            throw new RuntimeException();
        }
        return t;
    }

    public boolean updateByField(T t, SFunction<T, ?> field, Object fieldValue) {
        return ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(field, fieldValue)).update(t);
    }

    public List<T> findAll() {
        return this.lambdaQuery().list();
    }

    public <E extends IPage<T>> E page(E page) {
        return this.page(page, (Wrapper<T>)Wrappers.emptyWrapper());
    }

    public <E extends IPage<T>> E page(E page, Wrapper<T> queryWrapper) {
        return (E)this.getBaseMapper().selectPage(page, queryWrapper);
    }

    public Optional<T> findById(Serializable id) {
        return Optional.ofNullable(this.baseMapper.selectById(id));
    }

    public Optional<T> findByField(SFunction<T, ?> field, Object fieldValue) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(field, fieldValue)).oneOpt();
    }

    public List<T> findAllByIds(Collection<? extends Serializable> idList) {
        if (CollUtil.isEmpty(idList)) {
            return new ArrayList(0);
        }
        return this.baseMapper.selectByIds(idList);
    }

    public List<T> findAllByField(SFunction<T, ?> field, Object fieldValue) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(field, fieldValue)).list();
    }

    public List<T> findAllByFields(SFunction<T, ?> field, Collection<? extends Serializable> fieldValues) {
        if (CollUtil.isEmpty(fieldValues)) {
            return new ArrayList(0);
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(field, fieldValues)).list();
    }

    public boolean existedById(Serializable id) {
        String keyProperty = this.getKeyProperty();
        return ((QueryChainWrapper)this.query().eq((Object)keyProperty, (Object)id)).exists();
    }

    public boolean existedByField(SFunction<T, ?> field, Object fieldValue) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(field, fieldValue)).exists();
    }

    public boolean existedByField(SFunction<T, ?> field, Object fieldValue, Serializable id) {
        String keyProperty = this.getKeyProperty();
        return ((QueryChainWrapper)((QueryChainWrapper)this.query().eq((Object)MpUtils.getColumnName(field), fieldValue)).ne((Object)keyProperty, (Object)id)).exists();
    }

    public Long countByField(SFunction<T, ?> field, Object fieldValue) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(field, fieldValue)).count();
    }

    public boolean deleteByField(SFunction<T, ?> field, Object fieldValue) {
        return ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(field, fieldValue)).remove();
    }

    public boolean deleteByFields(SFunction<T, ?> field, Collection<?> fieldValues) {
        if (CollUtil.isEmpty(fieldValues)) {
            return false;
        }
        return ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(field, fieldValues)).remove();
    }

    public boolean deleteById(Serializable id) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        if (tableInfo.isWithLogicDelete() && tableInfo.isWithUpdateFill()) {
            return this.deleteById(id, true);
        }
        return SqlHelper.retBool((Integer)this.getBaseMapper().deleteById(id));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteByIds(Collection<?> list) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        if (tableInfo.isWithLogicDelete() && tableInfo.isWithUpdateFill()) {
            return this.deleteBatchByIds(list, this.DEFAULT_BATCH_SIZE, true);
        }
        return SqlHelper.retBool((Integer)this.getBaseMapper().deleteByIds(list));
    }

    private boolean deleteById(Serializable id, boolean useFill) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        if (useFill && tableInfo.isWithLogicDelete() && !this.getEntityClass().isAssignableFrom(id.getClass())) {
            Object instance = tableInfo.newInstance();
            tableInfo.setPropertyValue(instance, tableInfo.getKeyProperty(), new Object[]{id});
            return SqlHelper.retBool((Integer)this.getBaseMapper().deleteById(instance));
        }
        return SqlHelper.retBool((Integer)this.getBaseMapper().deleteById(id));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteBatchByIds(Collection<?> list, int batchSize, boolean useFill) {
        String sqlStatement = this.getSqlStatement(SqlMethod.DELETE_BY_ID);
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        return this.executeBatch(list, batchSize, (sqlSession, e) -> {
            if (useFill && tableInfo.isWithLogicDelete()) {
                if (this.getEntityClass().isAssignableFrom(e.getClass())) {
                    sqlSession.update(sqlStatement, e);
                } else {
                    Object instance = tableInfo.newInstance();
                    tableInfo.setPropertyValue(instance, tableInfo.getKeyProperty(), new Object[]{e});
                    sqlSession.update(sqlStatement, instance);
                }
            } else {
                sqlSession.update(sqlStatement, e);
            }
        });
    }
}

