/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.taotao.boot.common.model.BasePageQuery;
import com.taotao.boot.common.model.PageQuery;
import com.taotao.boot.common.model.PageResult;
import com.taotao.boot.common.utils.common.AntiSqlFilterUtils;
import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.text.StrUtil;

public class MpUtils {
    private static final int BATCH_SIZE = 1000;
    private static final String MYSQL_ESCAPE_CHARACTER = "`";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, M, R> int batchUpdateOrInsert(List<T> data, Class<M> mapperClass, BiFunction<T, M, R> function) {
        int i = 1;
        SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)ContextUtils.getBean(SqlSessionFactory.class, (boolean)true);
        if (Objects.isNull(sqlSessionFactory)) {
            throw new MybatisPlusException("\u672a\u83b7\u53d6\u5230sqlSession");
        }
        try (SqlSession sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);){
            Object mapper = sqlSession.getMapper(mapperClass);
            int size = data.size();
            for (T element : data) {
                function.apply(element, mapper);
                if (i % 1000 == 0 || i == size) {
                    sqlSession.flushStatements();
                }
                ++i;
            }
        }
        return i - 1;
    }

    public static <T> Optional<T> findOne(LambdaQueryChainWrapper<T> lambdaQuery) {
        Page mpPage = new Page(0L, 1L);
        Page page = (Page)lambdaQuery.page((IPage)mpPage);
        page.setSearchCount(false);
        if (CollUtil.isNotEmpty((Collection)page.getRecords())) {
            return Optional.of(page.getRecords().get(0));
        }
        return Optional.empty();
    }

    public static TableInfo getTableInfo(String tableName) {
        for (TableInfo tableInfo : TableInfoHelper.getTableInfos()) {
            if (!tableName.equalsIgnoreCase(tableInfo.getTableName())) continue;
            return tableInfo;
        }
        return null;
    }

    public static void addInterceptor(MybatisPlusInterceptor interceptor, InnerInterceptor inner, int index) {
        ArrayList<InnerInterceptor> inners = new ArrayList<InnerInterceptor>(interceptor.getInterceptors());
        inners.add(index, inner);
        interceptor.setInterceptors(inners);
    }

    public static String getTableName(Table table) {
        String tableName = table.getName();
        if (tableName.startsWith(MYSQL_ESCAPE_CHARACTER) && tableName.endsWith(MYSQL_ESCAPE_CHARACTER)) {
            tableName = tableName.substring(1, tableName.length() - 1);
        }
        return tableName;
    }

    public static Column buildColumn(String tableName, Alias tableAlias, String column) {
        return new Column((String)(tableAlias != null ? tableAlias.getName() + "." + column : column));
    }

    public static <T> String getColumnName(SFunction<T, ?> function) {
        LambdaMeta meta = LambdaUtils.extract(function);
        Map columnMap = LambdaUtils.getColumnMap((Class)meta.getInstantiatedClass());
        Assert.notEmpty((Map)columnMap, (String)"\u9519\u8bef:\u65e0\u6cd5\u6267\u884c.\u56e0\u4e3a\u65e0\u6cd5\u83b7\u53d6\u5230\u5b9e\u4f53\u7c7b\u7684\u8868\u5bf9\u5e94\u7f13\u5b58!", (Object[])new Object[0]);
        String fieldName = PropertyNamer.methodToProperty((String)meta.getImplMethodName());
        ColumnCache columnCache = (ColumnCache)columnMap.get(LambdaUtils.formatKey((String)fieldName));
        return columnCache.getColumn();
    }

    public static <T> String getColumnName(Method readMethod, Class<T> ... clazz) {
        Class<Object> beanClass = ArrayUtil.isNotEmpty((Object[])clazz) ? clazz[0] : readMethod.getDeclaringClass();
        Map columnMap = LambdaUtils.getColumnMap(beanClass);
        Assert.notEmpty((Map)columnMap, (String)"\u9519\u8bef:\u65e0\u6cd5\u6267\u884c.\u56e0\u4e3a\u65e0\u6cd5\u83b7\u53d6\u5230\u5b9e\u4f53\u7c7b\u7684\u8868\u5bf9\u5e94\u7f13\u5b58!", (Object[])new Object[0]);
        String fieldName = PropertyNamer.methodToProperty((String)readMethod.getName());
        ColumnCache columnCache = (ColumnCache)columnMap.get(LambdaUtils.formatKey((String)fieldName));
        return columnCache.getColumn();
    }

    public static <T> void executeBatch(List<T> saveList, Consumer<List<T>> consumer, int batchSize) {
        int start = 0;
        int end = Math.min(batchSize, saveList.size());
        while (start < end) {
            List list = ListUtil.sub(saveList, (int)start, (int)end);
            start = end;
            end = Math.min(end + batchSize, saveList.size());
            consumer.accept(list);
        }
    }

    @JsonIgnore
    public static <T, QueryDTO> IPage<T> buildMpPage(BasePageQuery<QueryDTO> params) {
        Page page = new Page((long)params.getCurrentPage().intValue(), (long)params.getPageSize().intValue());
        if (CollUtil.isEmpty((Collection)params.getSortQuery())) {
            return page;
        }
        ArrayList orders = new ArrayList();
        params.getSortQuery().forEach(sortDTO -> {
            String filed = sortDTO.getFiled();
            String order = sortDTO.getOrder();
            String underlineSort = StrUtil.toUnderlineCase((CharSequence)filed);
            if (!StrUtil.equalsAny((CharSequence)filed, (CharSequence[])new CharSequence[]{"createTime", "updateTime"})) {
                underlineSort = AntiSqlFilterUtils.getSafeValue((String)underlineSort);
            }
            if (StrUtil.equalsAny((CharSequence)order, (CharSequence[])new CharSequence[]{"asc"})) {
                orders.add(OrderItem.asc((String)underlineSort));
            } else {
                orders.add(OrderItem.desc((String)underlineSort));
            }
        });
        page.setOrders(orders);
        return page;
    }

    public static <T extends PageQuery, R> IPage<R> buildMpPage(T pageParam) {
        Page page = new Page((long)pageParam.getCurrentPage().intValue(), (long)pageParam.getPageSize().intValue());
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        orders.add(OrderItem.desc((String)"create_time"));
        if (StringUtils.isNotBlank((String)pageParam.getSort()) && StringUtils.isNotBlank((String)pageParam.getOrder())) {
            OrderItem orderItem = "asc".equals(pageParam.getOrder()) ? OrderItem.asc((String)pageParam.getSort()) : OrderItem.desc((String)pageParam.getSort());
            orders.add(orderItem);
        }
        page.setOrders(orders);
        return page;
    }

    public static <R, T> PageResult<R> convertMybatisPage(IPage<T> page, Function<T, R> function) {
        List records = page.getRecords();
        List<R> collect = ((List)Optional.ofNullable(records).orElse(new ArrayList())).stream().filter(Objects::nonNull).map(function).toList();
        return PageResult.of((long)page.getTotal(), (int)((int)page.getPages()), (int)((int)page.getCurrent()), (int)((int)page.getSize()), collect);
    }

    public static <R, T> PageResult<R> convertMybatisPage(IPage<T> page, Class<R> r) {
        return MpUtils.convertMybatisPage(page, (T t) -> BeanUtil.toBean((Object)t, (Class)r));
    }
}

