/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.aggregate;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.mybatisplus.aggregate.PaginationDTO;
import java.lang.reflect.Field;
import org.dromara.hutool.core.text.StrUtil;

public class AggregateQueries<T, C, R> {
    private T queries;
    private PaginationDTO pagination;
    private C condition;
    private R fuzzyQueries;
    private String sortField;
    private Integer sortType;

    public boolean hasQueries() {
        return this.queries != null;
    }

    public boolean hasPagination() {
        return this.pagination != null;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public boolean hasFuzzyQueries() {
        return this.fuzzyQueries != null;
    }

    public boolean hasSortField() {
        return this.sortField != null;
    }

    public boolean hasSortType() {
        return this.sortType != null;
    }

    public static <Q, T, C, R> QueryWrapper<Q> splicingAggregateQueries(QueryWrapper<Q> queries, AggregateQueries<T, C, R> aggregate) {
        if (aggregate.hasQueries()) {
            AggregateQueries.splicingQueries(queries, aggregate.getQueries());
        }
        if (aggregate.hasCondition()) {
            AggregateQueries.splicingQueries(queries, aggregate.getCondition());
        }
        if (aggregate.hasFuzzyQueries() && !aggregate.hasQueries()) {
            AggregateQueries.splicingFuzzyQueries(queries, aggregate.getFuzzyQueries());
        }
        if (aggregate.hasSortField()) {
            aggregate.setSortType(aggregate.hasSortType() ? aggregate.getSortType() : 0);
            AggregateQueries.applySort(queries, aggregate.getSortField(), aggregate.getSortType());
        }
        return queries;
    }

    public static <Q> QueryWrapper<Q> splicingQueries(QueryWrapper<Q> queries, Object obj) {
        Field[] declaredFields;
        for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String underlineCase = StrUtil.toUnderlineCase((CharSequence)field.getName());
            try {
                if (field.get(obj) == null) continue;
                queries.eq((Object)underlineCase, field.get(obj));
            }
            catch (IllegalAccessException e) {
                LogUtils.error((Throwable)e);
            }
        }
        return queries;
    }

    public static <Q> QueryWrapper<Q> splicingFuzzyQueries(QueryWrapper<Q> queries, Object obj) {
        Field[] declaredFields;
        for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String underlineCase = StrUtil.toUnderlineCase((CharSequence)field.getName());
            try {
                if (field.get(obj) == null) continue;
                queries.like((Object)underlineCase, field.get(obj));
            }
            catch (IllegalAccessException e) {
                LogUtils.error((Throwable)e);
            }
        }
        return queries;
    }

    private static <Q> void applySort(QueryWrapper<Q> wrapper, String sortField, int sortType) {
        String field = StrUtil.toUnderlineCase((CharSequence)sortField);
        if (sortType == 1) {
            wrapper.orderByDesc((Object)field);
        } else {
            wrapper.orderByAsc((Object)field);
        }
    }

    public T getQueries() {
        return this.queries;
    }

    public void setQueries(T queries) {
        this.queries = queries;
    }

    public PaginationDTO getPagination() {
        return this.pagination;
    }

    public void setPagination(PaginationDTO pagination) {
        this.pagination = pagination;
    }

    public C getCondition() {
        return this.condition;
    }

    public void setCondition(C condition) {
        this.condition = condition;
    }

    public R getFuzzyQueries() {
        return this.fuzzyQueries;
    }

    public void setFuzzyQueries(R fuzzyQueries) {
        this.fuzzyQueries = fuzzyQueries;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public Integer getSortType() {
        return this.sortType;
    }

    public void setSortType(Integer sortType) {
        this.sortType = sortType;
    }
}

