/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.aggregate.query.generator;

import com.taotao.boot.common.exception.BusinessException;
import com.taotao.boot.data.mybatis.mybatisplus.aggregate.query.code.ParamTypeEnum;
import com.taotao.boot.data.mybatis.mybatisplus.aggregate.query.entity.QueryParam;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.dromara.hutool.core.date.TimeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class ParamValueTypeConvert {
    public static Object initQueryParamValue(QueryParam queryParam) {
        Object paramValue = queryParam.getParamValue();
        if (Objects.isNull(paramValue)) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)queryParam.getParamType())) {
            return paramValue;
        }
        ParamTypeEnum paramTypeEnum = Optional.ofNullable(ParamTypeEnum.getByCode(queryParam.getParamType())).orElseThrow(() -> new BusinessException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b"));
        switch (paramTypeEnum) {
            case NUMBER: 
            case STRING: 
            case BOOLEAN: 
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                return ParamValueTypeConvert.convertType(paramValue, paramTypeEnum);
            }
            case LIST: {
                Collection collection = (Collection)paramValue;
                return collection.stream().map(o -> ParamValueTypeConvert.convertType(o, paramTypeEnum)).toList();
            }
        }
        return null;
    }

    private static Object convertType(Object paramValue, ParamTypeEnum paramTypeEnum) {
        ParamTypeEnum typeEnum = Optional.ofNullable(ParamTypeEnum.getByCode(paramTypeEnum.getCode())).orElseThrow(() -> new BusinessException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b"));
        switch (typeEnum) {
            case NUMBER: 
            case STRING: 
            case BOOLEAN: {
                return paramValue;
            }
            case DATE: {
                return TimeUtil.parse((CharSequence)((String)paramValue), (String)"yyyy-MM-dd");
            }
            case TIME: {
                return TimeUtil.parse((CharSequence)((String)paramValue), (String)"HH:mm:ss").toLocalTime();
            }
            case DATE_TIME: {
                return TimeUtil.parse((CharSequence)((String)paramValue), (String)"yyyy-MM-dd HH:mm:ss");
            }
            case LIST: {
                return paramValue;
            }
        }
        throw new BusinessException("\u7c7b\u578b\u9519\u8bef");
    }
}

