/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.aggregate.query.generator;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.taotao.boot.common.exception.BusinessException;
import com.taotao.boot.data.mybatis.mybatisplus.aggregate.query.code.CompareTypeEnum;
import com.taotao.boot.data.mybatis.mybatisplus.aggregate.query.entity.QueryBetweenParam;
import com.taotao.boot.data.mybatis.mybatisplus.aggregate.query.entity.QueryOrder;
import com.taotao.boot.data.mybatis.mybatisplus.aggregate.query.entity.QueryParam;
import com.taotao.boot.data.mybatis.mybatisplus.aggregate.query.entity.QueryParams;
import com.taotao.boot.data.mybatis.mybatisplus.aggregate.query.generator.ParamValueTypeConvert;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.text.StrUtil;

public class QueryGenerator {
    public static <T> QueryWrapper<T> generator(QueryParams queryParams) {
        QueryWrapper queryWrapper = new QueryWrapper();
        QueryGenerator.initQueryParam(queryWrapper, queryParams.getQueryParams());
        QueryGenerator.initQueryOrder(queryWrapper, queryParams.getQueryOrders());
        return queryWrapper;
    }

    private static <T> void initQueryParam(QueryWrapper<T> queryWrapper, List<QueryParam> queryParams) {
        if (CollUtil.isEmpty(queryParams)) {
            return;
        }
        for (QueryParam queryParam : queryParams) {
            List<QueryParam> nestedParams = queryParam.getNestedParams();
            if (queryParam.isOr() && CollUtil.isEmpty(nestedParams)) {
                queryWrapper.or();
            }
            if (CollUtil.isEmpty(nestedParams)) {
                QueryGenerator.initQueryParam(queryWrapper, queryParam);
                continue;
            }
            QueryParam q = new QueryParam();
            q.setParamName(queryParam.getParamName());
            q.setCompareType(queryParam.getCompareType());
            q.setParamType(queryParam.getParamType());
            q.setParamValue(queryParam.getParamValue());
            q.setUnderLine(queryParam.isUnderLine());
            q.setOr(queryParam.isOr());
            nestedParams.add(0, q);
            if (queryParam.isOr()) {
                queryWrapper.or(wrapper -> QueryGenerator.initQueryParam(wrapper, nestedParams));
                continue;
            }
            queryWrapper.and(wrapper -> QueryGenerator.initQueryParam(wrapper, nestedParams));
        }
    }

    private static <T> void initQueryParam(QueryWrapper<T> queryWrapper, QueryParam queryParam) {
        String paramName = QueryGenerator.initQueryParamName(queryParam);
        Object paramValue = ParamValueTypeConvert.initQueryParamValue(queryParam);
        CompareTypeEnum compareTypeEnum = Optional.ofNullable(CompareTypeEnum.getByCode(queryParam.getCompareType())).orElseThrow(() -> new BusinessException("\u67e5\u8be2\u5339\u914d\u7c7b\u578b\u975e\u6cd5"));
        switch (compareTypeEnum) {
            case GT: {
                queryWrapper.gt((Object)paramName, paramValue);
                break;
            }
            case GE: {
                queryWrapper.ge((Object)paramName, paramValue);
                break;
            }
            case LT: {
                queryWrapper.lt((Object)paramName, paramValue);
                break;
            }
            case LE: {
                queryWrapper.le((Object)paramName, paramValue);
                break;
            }
            case EQ: {
                queryWrapper.eq((Object)paramName, paramValue);
                break;
            }
            case NE: {
                queryWrapper.ne((Object)paramName, paramValue);
                break;
            }
            case IN: {
                queryWrapper.in((Object)paramName, (Collection)paramValue);
                break;
            }
            case NOT_IN: {
                queryWrapper.notIn((Object)paramName, (Collection)paramValue);
                break;
            }
            case BETWEEN: {
                if (Objects.isNull(paramValue)) {
                    throw new BusinessException("between \u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a");
                }
                QueryBetweenParam value = (QueryBetweenParam)paramValue;
                queryWrapper.between((Object)paramName, value.getStart(), value.getEnd());
                break;
            }
            case NOT_BETWEEN: {
                if (Objects.isNull(paramValue)) {
                    throw new BusinessException("between \u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a");
                }
                QueryBetweenParam value = (QueryBetweenParam)paramValue;
                queryWrapper.notBetween((Object)paramName, value.getStart(), value.getEnd());
                break;
            }
            case LIKE: {
                queryWrapper.like((Object)paramName, paramValue);
                break;
            }
            case NOT_LIKE: {
                queryWrapper.notLike((Object)paramName, paramValue);
                break;
            }
            case LIKE_LEFT: {
                queryWrapper.likeLeft((Object)paramName, paramValue);
                break;
            }
            case LIKE_RIGHT: {
                queryWrapper.likeRight((Object)paramName, paramValue);
                break;
            }
            case IS_NULL: {
                queryWrapper.isNull((Object)paramName);
                break;
            }
            case NOT_NULL: {
                queryWrapper.isNotNull((Object)paramName);
                break;
            }
            default: {
                throw new BusinessException("\u67e5\u8be2\u5339\u914d\u7c7b\u578b\u975e\u6cd5");
            }
        }
    }

    private static <T> void initQueryOrder(QueryWrapper<T> queryWrapper, List<QueryOrder> queryOrders) {
        if (CollUtil.isEmpty(queryOrders)) {
            return;
        }
        for (QueryOrder queryOrder : queryOrders) {
            if (queryOrder.isUnderLine()) {
                queryWrapper.orderBy(true, queryOrder.isAsc(), (Object)StrUtil.toUnderlineCase((CharSequence)queryOrder.getSortField()));
                continue;
            }
            queryWrapper.orderBy(true, queryOrder.isAsc(), (Object)queryOrder.getSortField());
        }
    }

    private static String initQueryParamName(QueryParam queryParam) {
        String paramName = queryParam.getParamName();
        if (queryParam.isUnderLine()) {
            return StrUtil.toUnderlineCase((CharSequence)paramName);
        }
        return paramName;
    }
}

