/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.handler.objecthandler;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.taotao.boot.common.holder.UserContextHolder;
import com.taotao.boot.common.utils.common.IdGeneratorUtils;
import com.taotao.boot.data.mybatis.mybatisplus.base.entity.MpSuperEntity;
import com.taotao.boot.data.mybatis.properties.MybatisPlusAutoFillProperties;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class AutoFieldMetaObjectHandler
implements MetaObjectHandler {
    private final MybatisPlusAutoFillProperties autoFillProperties;

    public AutoFieldMetaObjectHandler(MybatisPlusAutoFillProperties autoFillProperties) {
        this.autoFillProperties = autoFillProperties;
    }

    public boolean openInsertFill(MappedStatement mappedStatement) {
        return this.autoFillProperties.getEnableInsertFill();
    }

    public boolean openUpdateFill(MappedStatement mappedStatement) {
        return this.autoFillProperties.getEnableUpdateFill();
    }

    public void insertFill(MetaObject metaObject) {
        this.fillId(metaObject);
        Object createTime = this.getFieldValByName(this.autoFillProperties.getCreateTimeField(), metaObject);
        Object updateTime = this.getFieldValByName(this.autoFillProperties.getUpdateTimeField(), metaObject);
        if (createTime == null || updateTime == null) {
            if (createTime == null) {
                this.fillCreated(metaObject);
            }
            if (updateTime == null) {
                this.fillUpdated(metaObject);
            }
        }
    }

    private void fillId(MetaObject metaObject) {
        Long id = IdGeneratorUtils.getId();
        if (metaObject.getOriginalObject() instanceof MpSuperEntity) {
            Object oldId = ((MpSuperEntity)metaObject.getOriginalObject()).getId();
            if (oldId != null) {
                return;
            }
            Object idVal = "java.lang.String".equals(metaObject.getGetterType(this.autoFillProperties.getIdField()).getName()) ? String.valueOf(id) : id;
            this.setFieldValByName(this.autoFillProperties.getIdField(), idVal, metaObject);
            return;
        }
        if (metaObject.hasGetter(this.autoFillProperties.getIdField())) {
            Object oldId = metaObject.getValue(this.autoFillProperties.getIdField());
            if (oldId != null) {
                return;
            }
            Object idVal = "java.lang.String".equals(metaObject.getGetterType(this.autoFillProperties.getIdField()).getName()) ? String.valueOf(id) : id;
            this.setFieldValByName(this.autoFillProperties.getIdField(), idVal, metaObject);
            return;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(metaObject.getOriginalObject().getClass());
        if (tableInfo == null) {
            return;
        }
        Class keyType = tableInfo.getKeyType();
        if (keyType == null) {
            return;
        }
        String keyProperty = tableInfo.getKeyProperty();
        Object oldId = metaObject.getValue(keyProperty);
        if (oldId != null) {
            return;
        }
        Field idField = FieldUtil.getField(metaObject.getOriginalObject().getClass(), (String)keyProperty);
        Object fieldValue = FieldUtil.getFieldValue((Object)metaObject.getOriginalObject(), (Field)idField);
        if (ObjUtil.isNotEmpty((Object)fieldValue)) {
            return;
        }
        Object idVal = keyType.getName().equalsIgnoreCase("java.lang.String") ? String.valueOf(id) : id;
        this.setFieldValByName(keyProperty, idVal, metaObject);
    }

    private void fillCreated(MetaObject metaObject) {
        Object oldVal;
        if (metaObject.getOriginalObject() instanceof MpSuperEntity) {
            this.created(metaObject);
            return;
        }
        if (metaObject.hasGetter(this.autoFillProperties.getCreateByField()) && (oldVal = metaObject.getValue(this.autoFillProperties.getCreateByField())) == null) {
            this.setFieldValByName(this.autoFillProperties.getCreateByField(), UserContextHolder.getUserId(), metaObject);
        }
        if (metaObject.hasGetter(this.autoFillProperties.getCreateTimeField()) && (oldVal = metaObject.getValue(this.autoFillProperties.getCreateTimeField())) == null) {
            this.setFieldValByName(this.autoFillProperties.getCreateTimeField(), LocalDateTime.now(), metaObject);
        }
    }

    private void created(MetaObject metaObject) {
        MpSuperEntity entity = (MpSuperEntity)metaObject.getOriginalObject();
        if (entity.getCreateTime() == null) {
            this.setFieldValByName(this.autoFillProperties.getCreateTimeField(), LocalDateTime.now(), metaObject);
        }
        if (entity.getCreatedBy() == null || entity.getCreatedBy().equals(0)) {
            Long userIdVal = UserContextHolder.getUserId();
            this.setFieldValByName("createdBy", userIdVal, metaObject);
        }
    }

    private void fillUpdated(MetaObject metaObject) {
        Object oldVal;
        if (metaObject.getOriginalObject() instanceof MpSuperEntity) {
            this.update(metaObject);
            return;
        }
        if (metaObject.hasGetter(this.autoFillProperties.getUpdateByField()) && (oldVal = metaObject.getValue(this.autoFillProperties.getUpdateByField())) == null) {
            this.setFieldValByName(this.autoFillProperties.getUpdateByField(), UserContextHolder.getUserId(), metaObject);
        }
        if (metaObject.hasGetter(this.autoFillProperties.getUpdateTimeField()) && (oldVal = metaObject.getValue(this.autoFillProperties.getUpdateTimeField())) == null) {
            this.setFieldValByName(this.autoFillProperties.getUpdateTimeField(), LocalDateTime.now(), metaObject);
        }
    }

    private void update(MetaObject metaObject) {
        MpSuperEntity entity = (MpSuperEntity)metaObject.getOriginalObject();
        if (entity.getUpdatedBy() == null || entity.getUpdatedBy().equals(0)) {
            Long userIdVal = UserContextHolder.getUserId();
            this.setFieldValByName("updatedBy", userIdVal, metaObject);
        }
        if (entity.getUpdateTime() == null) {
            this.setFieldValByName(this.autoFillProperties.getUpdateTimeField(), LocalDateTime.now(), metaObject);
        }
    }

    public void updateFill(MetaObject metaObject) {
        this.fillUpdated(metaObject);
    }
}

