/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.datachanage.configuration;

import com.taotao.boot.cache.redis.repository.RedisRepository;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datachanage.configuration.DataVersionLogKafkaServiceConfiguration;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datachanage.service.DataVersionLogService;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datachanage.service.impl.DataVersionLogRedisService;
import com.taotao.boot.data.mybatis.properties.MybatisPlusInterceptorProperties;
import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={RedisRepository.class})
@ConditionalOnBean(value={RedisRepository.class})
@ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus.interceptor.data-change", name={"enabled"}, havingValue="true")
public class DataVersionLogRedisServiceConfiguration
implements InitializingBean {
    @Autowired
    private MybatisPlusInterceptorProperties mybatisPlusInterceptorProperties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(DataVersionLogKafkaServiceConfiguration.class, (String)"taotao-boot-starter-logger", (String[])new String[0]);
    }

    @Bean
    public DataVersionLogService dataVersionLogRedisService(RedisRepository redisRepository) {
        MybatisPlusInterceptorProperties.DataChange.StoreType[] types = this.mybatisPlusInterceptorProperties.getDataChange().getTypes();
        if (Arrays.stream(types).anyMatch(e -> e.name().equals(MybatisPlusInterceptorProperties.DataChange.StoreType.REDIS.name()))) {
            return new DataVersionLogRedisService(redisRepository);
        }
        return null;
    }
}

