/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.datachanage.interceptor;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.mybatisplus.MpUtils;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datachanage.annotation.DataVersionLog;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datachanage.model.DataVersionLogData;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datachanage.service.DataVersionLogService;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;

public class DataChangeRecorderInnerInterceptor
implements InnerInterceptor {
    public static final String IGNORED_TABLE_COLUMN_PROPERTIES = "ignoredTableColumns";
    private final Map<String, Set<String>> ignoredTableColumns = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> ignoreAllColumns = new HashSet<String>();

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        BoundSql boundSql = mpSh.boundSql();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            OperationResult operationResult;
            DataVersionLog dataVersion;
            long startTs;
            block8: {
                PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
                startTs = System.currentTimeMillis();
                try {
                    Statement statement = CCJSqlParserUtil.parse((String)mpBs.sql());
                    dataVersion = this.getDataVersionAnno(statement);
                    if (Objects.isNull(dataVersion)) {
                        return;
                    }
                    if (statement instanceof Insert) {
                        operationResult = this.processInsert((Insert)statement, mpSh.boundSql());
                        break block8;
                    }
                    if (statement instanceof Update) {
                        operationResult = this.processUpdate((Update)statement, ms, boundSql, connection);
                        break block8;
                    }
                    if (statement instanceof Delete) {
                        operationResult = this.processDelete((Delete)statement, ms, boundSql, connection);
                        break block8;
                    }
                    return;
                }
                catch (Exception e) {
                    LogUtils.error((String)"Unexpected error for mappedStatement={}, sql={}", (Object[])new Object[]{ms.getId(), mpBs.sql(), e});
                    return;
                }
            }
            long costThis = System.currentTimeMillis() - startTs;
            if (operationResult != null) {
                operationResult.setCost(costThis);
                operationResult.setAnnotation(dataVersion);
                this.dealOperationResult(operationResult);
            }
        }
    }

    protected DataVersionLog getDataVersionAnno(Statement statement) {
        String tableName;
        if (statement instanceof Insert) {
            tableName = ((Insert)statement).getTable().getName();
        } else if (statement instanceof Update) {
            tableName = ((Update)statement).getTable().getName();
        } else if (statement instanceof Delete) {
            tableName = ((Delete)statement).getTable().getName();
        } else {
            return null;
        }
        TableInfo tableInfo = MpUtils.getTableInfo(tableName);
        if (Objects.isNull(tableInfo)) {
            return null;
        }
        return tableInfo.getEntityType().getAnnotation(DataVersionLog.class);
    }

    protected void dealOperationResult(OperationResult operationResult) {
        DataVersionLog annotation = operationResult.getAnnotation();
        List<DataChangedRecord> changedRecords = operationResult.getChangedRecords();
        for (DataChangedRecord changedRecord : changedRecords) {
            Object originalColumn2;
            List originalColumns = Optional.ofNullable(changedRecord.getOriginalColumns()).orElse(new ArrayList(0));
            HashMap<String, Object> dataRecord = new HashMap<String, Object>();
            HashMap updateRecord = new HashMap();
            for (Object originalColumn2 : originalColumns) {
                dataRecord.put(((DataColumnChangeResult)originalColumn2).getColumnName(), ((DataColumnChangeResult)originalColumn2).getOriginalValue());
            }
            List updatedColumns = Optional.ofNullable(changedRecord.getUpdatedColumns()).orElse(new ArrayList(0));
            originalColumn2 = updatedColumns.iterator();
            while (originalColumn2.hasNext()) {
                DataColumnChangeResult updatedColumn = (DataColumnChangeResult)originalColumn2.next();
                updateRecord.put(updatedColumn.getColumnName(), dataRecord.get(updatedColumn.getColumnName()));
                dataRecord.put(updatedColumn.getColumnName(), updatedColumn.getUpdateValue());
            }
            Object pkColumnVal = changedRecord.getPkColumnVal();
            if ("insert".equals(operationResult.getOperation())) {
                String keyProperty = Optional.ofNullable(MpUtils.getTableInfo(operationResult.getTableName())).map(TableInfo::getKeyProperty).map(String::toUpperCase).orElse(null);
                pkColumnVal = dataRecord.get(keyProperty);
            }
            DataVersionLogData dataVersionLogData = new DataVersionLogData();
            dataVersionLogData.setTableName(operationResult.getTableName());
            dataVersionLogData.setDataName(annotation.title());
            dataVersionLogData.setDataId(pkColumnVal.toString());
            dataVersionLogData.setDataContent(dataRecord);
            dataVersionLogData.setChangeContent(updateRecord);
            dataVersionLogData.setVersion(0);
            List dataVersionLogServices = ContextUtils.getBeansOfTypeWithList(DataVersionLogService.class);
            if (dataVersionLogServices == null || dataVersionLogServices.isEmpty()) continue;
            dataVersionLogServices.forEach(service -> service.add(dataVersionLogData));
        }
    }

    public OperationResult processInsert(Insert insertStmt, BoundSql boundSql) {
        OperationResult result = new OperationResult();
        result.setOperation("insert");
        result.setTableName(insertStmt.getTable().getName());
        result.setRecordStatus(true);
        result.setChangedRecords(this.compareAndGetUpdatedColumnDatas(result.getTableName(), boundSql, (Statement)insertStmt, null));
        return result;
    }

    public OperationResult processUpdate(Update updateStmt, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        Expression where = updateStmt.getWhere();
        PlainSelect selectBody = new PlainSelect();
        Table table = updateStmt.getTable();
        Set<String> ignoredColumns = this.ignoredTableColumns.get(table.getName().toUpperCase());
        if (ignoredColumns != null && ignoredColumns.stream().anyMatch("*"::equals)) {
            OperationResult result = new OperationResult();
            result.setOperation("update");
            result.setTableName(table.getName() + ":*");
            result.setRecordStatus(false);
            return result;
        }
        selectBody.setFromItem((FromItem)table);
        ArrayList<Column> updateColumns = new ArrayList<Column>();
        for (UpdateSet updateSet : updateStmt.getUpdateSets()) {
            updateColumns.addAll((Collection<Column>)updateSet.getColumns());
        }
        Columns2SelectItemsResult buildColumns2SelectItems = this.buildColumns2SelectItems(table.getName(), updateColumns);
        return null;
    }

    private List<ParameterMapping> prepareParameterMapping4Select(List<ParameterMapping> originalMappingList, Update updateStmt) {
        ArrayList updateValueExpressions = new ArrayList();
        for (Object object : updateStmt.getUpdateSets()) {
        }
        int removeParamCount = 0;
        for (Expression expression : updateValueExpressions) {
            if (!(expression instanceof JdbcParameter)) continue;
            ++removeParamCount;
        }
        return originalMappingList.subList(removeParamCount, originalMappingList.size());
    }

    private List<DataChangedRecord> compareAndGetUpdatedColumnDatas(String tableName, BoundSql updateSql, Statement statement, OriginalDataObj originalDataObj) {
        HashMap<String, Object> columnNameValMap = new HashMap<String, Object>(updateSql.getParameterMappings().size());
        ArrayList selectItemsFromUpdateSql = new ArrayList();
        if (statement instanceof Update) {
            Update updateStmt = (Update)statement;
            for (UpdateSet updateSet : updateStmt.getUpdateSets()) {
                selectItemsFromUpdateSql.addAll(updateSet.getColumns());
            }
        } else if (statement instanceof Insert) {
            selectItemsFromUpdateSql.addAll(((Insert)statement).getColumns());
        }
        HashMap<String, String> relatedColumnsUpperCaseWithoutUnderline = new HashMap<String, String>(selectItemsFromUpdateSql.size(), 1.0f);
        for (Object item : selectItemsFromUpdateSql) {
            relatedColumnsUpperCaseWithoutUnderline.put(item.toString().replaceAll("[._\\-$]", "").toUpperCase(), item.toString().toUpperCase());
        }
        MetaObject metaObject = SystemMetaObject.forObject((Object)updateSql.getParameterObject());
        for (ParameterMapping parameterMapping : updateSql.getParameterMappings()) {
            String[] arr;
            String string;
            String propertyName = parameterMapping.getProperty();
            if (propertyName.startsWith("ew.paramNameValuePairs") || !relatedColumnsUpperCaseWithoutUnderline.containsKey(string = (arr = propertyName.split("\\."))[arr.length - 1].replace("_", "").toUpperCase())) continue;
            columnNameValMap.put((String)relatedColumnsUpperCaseWithoutUnderline.get(string), metaObject.getValue(propertyName));
        }
        Set<String> ignoredColumns = this.ignoredTableColumns.get(tableName.toUpperCase());
        if (originalDataObj == null || originalDataObj.isEmpty()) {
            DataChangedRecord oneRecord = new DataChangedRecord();
            ArrayList<DataColumnChangeResult> updateColumns = new ArrayList<DataColumnChangeResult>(columnNameValMap.size());
            for (Map.Entry entry : columnNameValMap.entrySet()) {
                String columnName = (String)entry.getKey();
                if (ignoredColumns != null && ignoredColumns.contains(columnName) || this.ignoreAllColumns.contains(columnName)) continue;
                updateColumns.add(DataColumnChangeResult.constrcutByUpdateVal(columnName, entry.getValue()));
            }
            oneRecord.setUpdatedColumns(updateColumns);
            return Collections.singletonList(oneRecord);
        }
        List<DataChangedRecord> originalDataList = originalDataObj.getOriginalDataObj();
        ArrayList<DataChangedRecord> updateDataList = new ArrayList<DataChangedRecord>(originalDataList.size());
        for (DataChangedRecord dataChangedRecord : originalDataList) {
            if (!dataChangedRecord.hasUpdate(columnNameValMap, ignoredColumns, this.ignoreAllColumns)) continue;
            updateDataList.add(dataChangedRecord);
        }
        return updateDataList;
    }

    private String buildOriginalData(Select selectStmt, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        String string;
        block12: {
            PreparedStatement statement = connection.prepareStatement(selectStmt.toString());
            try {
                DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), boundSql);
                parameterHandler.setParameters(statement);
                ResultSet resultSet = statement.executeQuery();
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columnCount = metaData.getColumnCount();
                StringBuilder sb = new StringBuilder("[");
                while (resultSet.next()) {
                    sb.append("{");
                    for (int i = 1; i <= columnCount; ++i) {
                        sb.append("\"").append(metaData.getColumnName(i)).append("\":\"");
                        Object res = resultSet.getObject(i);
                        if (res instanceof Clob) {
                            sb.append(DataColumnChangeResult.convertClob((Clob)res));
                        } else {
                            sb.append(res);
                        }
                        sb.append("\",");
                    }
                    sb.replace(sb.length() - 1, sb.length(), "}");
                }
                sb.append("]");
                resultSet.close();
                string = sb.toString();
                if (statement == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LogUtils.error((String)"try to get record tobe deleted for selectStmt={}", (Object[])new Object[]{selectStmt, e});
                    return "failed to get original data";
                }
            }
            statement.close();
        }
        return string;
    }

    private OriginalDataObj buildOriginalObjectData(Select selectStmt, Column pk, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        OriginalDataObj originalDataObj;
        block9: {
            PreparedStatement statement = connection.prepareStatement(selectStmt.toString());
            try {
                DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), boundSql);
                parameterHandler.setParameters(statement);
                ResultSet resultSet = statement.executeQuery();
                LinkedList<DataChangedRecord> originalObjectDatas = new LinkedList<DataChangedRecord>();
                while (resultSet.next()) {
                    originalObjectDatas.add(this.prepareOriginalDataObj(resultSet, pk));
                }
                OriginalDataObj result = new OriginalDataObj();
                result.setOriginalDataObj(originalObjectDatas);
                resultSet.close();
                originalDataObj = result;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LogUtils.error((String)"try to get record tobe updated for selectStmt={}", (Object[])new Object[]{selectStmt, e});
                    return new OriginalDataObj();
                }
            }
            statement.close();
        }
        return originalDataObj;
    }

    private DataChangedRecord prepareOriginalDataObj(ResultSet resultSet, Column pk) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        LinkedList<DataColumnChangeResult> originalColumnDatas = new LinkedList<DataColumnChangeResult>();
        DataColumnChangeResult pkval = null;
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = metaData.getColumnName(i).toUpperCase();
            DataColumnChangeResult col = DataColumnChangeResult.constrcutByOriginalVal(columnName, resultSet.getObject(i));
            if (pk != null && columnName.equalsIgnoreCase(pk.getColumnName())) {
                pkval = col;
                continue;
            }
            originalColumnDatas.add(col);
        }
        DataChangedRecord changedRecord = new DataChangedRecord();
        changedRecord.setOriginalColumns(originalColumnDatas);
        if (pkval != null) {
            changedRecord.setPkColumnName(pkval.getColumnName());
            changedRecord.setPkColumnVal(pkval.getOriginalValue());
        }
        return changedRecord;
    }

    private Columns2SelectItemsResult buildColumns2SelectItems(String tableName, List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            // empty if block
        }
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>(columns.size());
        for (Column column : columns) {
        }
        for (Column column : TableInfoHelper.getTableInfos()) {
        }
        return Columns2SelectItemsResult.build(selectItems, 0);
    }

    public OperationResult processDelete(Delete deleteStmt, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        Table table = deleteStmt.getTable();
        Expression where = deleteStmt.getWhere();
        return null;
    }

    public void setProperties(Properties properties) {
        String[] array;
        String ignoredTableColumns = properties.getProperty(IGNORED_TABLE_COLUMN_PROPERTIES);
        if (ignoredTableColumns == null || ignoredTableColumns.trim().isEmpty()) {
            return;
        }
        for (String table : array = ignoredTableColumns.split(";")) {
            int index = table.indexOf(".");
            if (index == -1) {
                LogUtils.warn((String)"invalid data={} for ignoredColumns, format should be TABLE_NAME1.COLUMN1,COLUMN2; TABLE2.COLUMN1,COLUMN2;", (Object[])new Object[]{table});
                continue;
            }
            String tableName = table.substring(0, index).trim().toUpperCase();
            String[] columnArray = table.substring(index + 1).split(",");
            HashSet<String> columnSet = new HashSet<String>(columnArray.length);
            for (String column : columnArray) {
                if ((column = column.trim().toUpperCase()).isEmpty()) continue;
                columnSet.add(column);
            }
            if ("*".equals(tableName)) {
                this.ignoreAllColumns.addAll(columnSet);
                continue;
            }
            this.ignoredTableColumns.put(tableName, columnSet);
        }
    }

    public static class OperationResult {
        private String operation;
        private boolean recordStatus;
        private String tableName;
        @Deprecated
        private String changedData;
        private List<DataChangedRecord> changedRecords;
        private DataVersionLog annotation;
        private long cost;

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public boolean isRecordStatus() {
            return this.recordStatus;
        }

        public void setRecordStatus(boolean recordStatus) {
            this.recordStatus = recordStatus;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getChangedData() {
            return this.changedData;
        }

        public void setChangedData(String changedData) {
            this.changedData = changedData;
        }

        public List<DataChangedRecord> getChangedRecords() {
            return this.changedRecords;
        }

        public void setChangedRecords(List<DataChangedRecord> changedRecords) {
            this.changedRecords = changedRecords;
        }

        public DataVersionLog getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(DataVersionLog annotation) {
            this.annotation = annotation;
        }

        public long getCost() {
            return this.cost;
        }

        public void setCost(long cost) {
            this.cost = cost;
        }
    }

    public static class DataChangedRecord {
        private String pkColumnName;
        private Object pkColumnVal;
        private List<DataColumnChangeResult> originalColumns;
        private List<DataColumnChangeResult> updatedColumns;

        public String getPkColumnName() {
            return this.pkColumnName;
        }

        public void setPkColumnName(String pkColumnName) {
            this.pkColumnName = pkColumnName;
        }

        public Object getPkColumnVal() {
            return this.pkColumnVal;
        }

        public void setPkColumnVal(Object pkColumnVal) {
            this.pkColumnVal = pkColumnVal;
        }

        public List<DataColumnChangeResult> getOriginalColumns() {
            return this.originalColumns;
        }

        public void setOriginalColumns(List<DataColumnChangeResult> originalColumns) {
            this.originalColumns = originalColumns;
        }

        public List<DataColumnChangeResult> getUpdatedColumns() {
            return this.updatedColumns;
        }

        public void setUpdatedColumns(List<DataColumnChangeResult> updatedColumns) {
            this.updatedColumns = updatedColumns;
        }

        public boolean hasUpdate(Map<String, Object> columnNameValMap, Set<String> ignoredColumns, Set<String> ignoreAllColumns) {
            if (this.originalColumns == null) {
                return true;
            }
            boolean hasUpdate = false;
            this.updatedColumns = new ArrayList<DataColumnChangeResult>(this.originalColumns.size());
            for (DataColumnChangeResult originalColumn : this.originalColumns) {
                Object updatedValue;
                String columnName = originalColumn.getColumnName().toUpperCase();
                if (ignoredColumns != null && ignoredColumns.contains(columnName) || ignoreAllColumns.contains(columnName) || !originalColumn.isDataChanged(updatedValue = columnNameValMap.get(columnName))) continue;
                hasUpdate = true;
                originalColumn.setUpdateValue(updatedValue);
                this.updatedColumns.add(originalColumn);
            }
            return hasUpdate;
        }

        public String generateUpdatedDataStr() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (this.pkColumnName != null) {
                sb.append("\"").append(this.pkColumnName).append("\"").append(":").append("\"").append(this.convertDoubleQuotes(this.pkColumnVal)).append("\"").append(",");
            }
            for (DataColumnChangeResult update : this.updatedColumns) {
                sb.append(update.generateDataStr());
            }
            sb.replace(sb.length() - 1, sb.length(), "}");
            return sb.toString();
        }

        public String convertDoubleQuotes(Object obj) {
            if (obj == null) {
                return null;
            }
            return obj.toString().replace("\"", "\\\"");
        }
    }

    public static class DataColumnChangeResult {
        private String columnName;
        private Object originalValue;
        private Object updateValue;

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public Object getOriginalValue() {
            return this.originalValue;
        }

        public void setOriginalValue(Object originalValue) {
            this.originalValue = originalValue;
        }

        public Object getUpdateValue() {
            return this.updateValue;
        }

        public void setUpdateValue(Object updateValue) {
            this.updateValue = updateValue;
        }

        public boolean isDataChanged(Object updateValue) {
            if (!Objects.equals(this.originalValue, updateValue)) {
                if (updateValue instanceof Number && this.originalValue instanceof Number) {
                    BigDecimal original;
                    BigDecimal update = new BigDecimal(updateValue.toString());
                    return update.compareTo(original = new BigDecimal(this.originalValue.toString())) != 0;
                }
                if (updateValue instanceof Date && this.originalValue instanceof Date) {
                    Date update = (Date)updateValue;
                    Date original = (Date)this.originalValue;
                    return update.compareTo(original) != 0;
                }
                if (this.originalValue instanceof Clob) {
                    String originalStr = DataColumnChangeResult.convertClob((Clob)this.originalValue);
                    this.setOriginalValue(originalStr);
                    return !originalStr.equals(updateValue);
                }
                return true;
            }
            Object original = this.originalValue;
            if (original instanceof Comparable) {
                Comparable original2 = (Comparable)original;
                Comparable update = (Comparable)updateValue;
                return original2.compareTo(update) != 0;
            }
            return false;
        }

        public static String convertClob(Clob clobObj) {
            try {
                return clobObj.getSubString(0L, (int)clobObj.length());
            }
            catch (Exception e) {
                String string;
                block11: {
                    Reader is = clobObj.getCharacterStream();
                    try {
                        int readChars;
                        char[] chars = new char[64];
                        StringBuilder sb = new StringBuilder();
                        while ((readChars = is.read(chars)) != -1) {
                            sb.append(chars, 0, readChars);
                        }
                        string = sb.toString();
                        if (is == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e2) {
                            return "unknown clobObj";
                        }
                    }
                    is.close();
                }
                return string;
            }
        }

        public static DataColumnChangeResult constrcutByUpdateVal(String columnName, Object updateValue) {
            DataColumnChangeResult res = new DataColumnChangeResult();
            res.setColumnName(columnName);
            res.setUpdateValue(updateValue);
            return res;
        }

        public static DataColumnChangeResult constrcutByOriginalVal(String columnName, Object originalValue) {
            DataColumnChangeResult res = new DataColumnChangeResult();
            res.setColumnName(columnName);
            res.setOriginalValue(originalValue);
            return res;
        }

        public String generateDataStr() {
            StringBuilder sb = new StringBuilder();
            sb.append("\"").append(this.columnName).append("\"").append(":").append("\"").append(this.convertDoubleQuotes(this.originalValue)).append("->").append(this.convertDoubleQuotes(this.updateValue)).append("\"").append(",");
            return sb.toString();
        }

        public String convertDoubleQuotes(Object obj) {
            if (obj == null) {
                return null;
            }
            return obj.toString().replace("\"", "\\\"");
        }
    }

    public static class OriginalDataObj {
        private List<DataChangedRecord> originalDataObj;

        public List<DataChangedRecord> getOriginalDataObj() {
            return this.originalDataObj;
        }

        public void setOriginalDataObj(List<DataChangedRecord> originalDataObj) {
            this.originalDataObj = originalDataObj;
        }

        public boolean isEmpty() {
            return this.originalDataObj == null || this.originalDataObj.isEmpty();
        }
    }

    public static class Columns2SelectItemsResult {
        private Column pk;
        private List<SelectItem> selectItems;
        private int additionalItemCount;

        public Column getPk() {
            return this.pk;
        }

        public void setPk(Column pk) {
            this.pk = pk;
        }

        public List<SelectItem> getSelectItems() {
            return this.selectItems;
        }

        public void setSelectItems(List<SelectItem> selectItems) {
            this.selectItems = selectItems;
        }

        public int getAdditionalItemCount() {
            return this.additionalItemCount;
        }

        public void setAdditionalItemCount(int additionalItemCount) {
            this.additionalItemCount = additionalItemCount;
        }

        public static Columns2SelectItemsResult build(List<SelectItem> selectItems, int additionalItemCount) {
            Columns2SelectItemsResult result = new Columns2SelectItemsResult();
            result.setSelectItems(selectItems);
            result.setAdditionalItemCount(additionalItemCount);
            return result;
        }
    }
}

