/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.dataPermission.dept.rule;

import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.taotao.boot.common.holder.UserContextHolder;
import com.taotao.boot.common.model.BaseSecurityUser;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.mybatisplus.MpUtils;
import com.taotao.boot.data.mybatis.mybatisplus.base.entity.MpSuperEntity;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.dataPermission.dept.service.DeptDataPermissionFrameworkService;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.dataPermission.dept.service.DeptDataPermissionRespEntity;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.dataPermission.rule.DataPermissionRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.text.StrUtil;

public class DeptDataPermissionRule
implements DataPermissionRule {
    private static final String DEPT_COLUMN_NAME = "dept_id";
    private static final String USER_COLUMN_NAME = "user_id";
    static final Expression EXPRESSION_NULL = new NullValue();
    private final DeptDataPermissionFrameworkService deptDataPermissionService;
    private final Map<String, String> deptColumns = new HashMap<String, String>();
    private final Map<String, String> userColumns = new HashMap<String, String>();
    private final Set<String> TABLE_NAMES = new HashSet<String>();

    public DeptDataPermissionRule(DeptDataPermissionFrameworkService deptDataPermissionService) {
        this.deptDataPermissionService = deptDataPermissionService;
    }

    @Override
    public Set<String> getTableNames() {
        return this.TABLE_NAMES;
    }

    @Override
    public Expression getExpression(String tableName, Alias tableAlias) {
        BaseSecurityUser loginUser = UserContextHolder.getUser();
        if (Objects.isNull(loginUser)) {
            return null;
        }
        DeptDataPermissionRespEntity deptDataPermission = this.deptDataPermissionService.getDeptDataPermission(loginUser);
        if (Objects.isNull(deptDataPermission)) {
            LogUtils.info((String)"\u83b7\u53d6\u7528\u6237:{} \u6570\u636e\u6743\u9650\u4e3a null", (Object[])new Object[]{loginUser});
            throw new NullPointerException(String.format("LoginUser(%d) Table(%s/%s) \u672a\u8fd4\u56de\u6570\u636e\u6743\u9650", loginUser.getUserId(), tableName, tableAlias.getName()));
        }
        if (deptDataPermission.getAll()) {
            return null;
        }
        if (CollUtil.isEmpty(deptDataPermission.getDeptIds()) && Boolean.FALSE.equals(deptDataPermission.getSelf())) {
            return new EqualsTo(null, null);
        }
        Expression deptExpression = this.buildDeptExpression(tableName, tableAlias, deptDataPermission.getDeptIds());
        Expression userExpression = this.buildUserExpression(tableName, tableAlias, deptDataPermission.getSelf(), loginUser.getUserId());
        if (Objects.isNull(deptExpression) && Objects.isNull(userExpression)) {
            LogUtils.warn((String)"LoginUser{} Table{}/{} DeptDataPermission{} \u6784\u5efa\u7684\u6761\u4ef6\u4e3a\u7a7a", (Object[])new Object[]{loginUser, tableName, tableAlias, deptDataPermission});
            return EXPRESSION_NULL;
        }
        if (Objects.isNull(deptExpression)) {
            return userExpression;
        }
        if (Objects.isNull(userExpression)) {
            return deptExpression;
        }
        return new OrExpression(deptExpression, userExpression);
    }

    private Expression buildDeptExpression(String tableName, Alias tableAlias, Set<Long> deptIds) {
        String columnName = this.deptColumns.get(tableName);
        if (StrUtil.isEmpty((CharSequence)columnName)) {
            return null;
        }
        if (CollUtil.isEmpty(deptIds)) {
            return null;
        }
        return new InExpression((Expression)MpUtils.buildColumn(tableName, tableAlias, columnName), (Expression)new ExpressionList(deptIds.stream().map(LongValue::new).collect(Collectors.toList())));
    }

    private Expression buildUserExpression(String tableName, Alias tableAlias, Boolean self, Long userId) {
        if (Boolean.FALSE.equals(self)) {
            return null;
        }
        String columnName = this.userColumns.get(tableName);
        if (StrUtil.isEmpty((CharSequence)columnName)) {
            return null;
        }
        return new EqualsTo((Expression)MpUtils.buildColumn(tableName, tableAlias, columnName), (Expression)new LongValue(userId.longValue()));
    }

    public void addDeptColumn(Class<? extends MpSuperEntity> entityClass) {
        this.addDeptColumn(entityClass, DEPT_COLUMN_NAME);
    }

    public void addDeptColumn(Class<? extends MpSuperEntity> entityClass, String columnName) {
        String tableName = TableInfoHelper.getTableInfo(entityClass).getTableName();
        this.addDeptColumn(tableName, columnName);
    }

    public void addDeptColumn(String tableName, String columnName) {
        this.deptColumns.put(tableName, columnName);
        this.TABLE_NAMES.add(tableName);
    }

    public void addUserColumn(Class<? extends MpSuperEntity> entityClass) {
        this.addUserColumn(entityClass, USER_COLUMN_NAME);
    }

    public void addUserColumn(Class<? extends MpSuperEntity> entityClass, String columnName) {
        String tableName = TableInfoHelper.getTableInfo(entityClass).getTableName();
        this.addUserColumn(tableName, columnName);
    }

    public void addUserColumn(String tableName, String columnName) {
        this.userColumns.put(tableName, columnName);
        this.TABLE_NAMES.add(tableName);
    }
}

