/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.datascope.aspect;

import com.taotao.boot.common.holder.UserContextHolder;
import com.taotao.boot.common.model.BaseSecurityUser;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.datascope.annotation.DataScope;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataScopeAspect {
    public static final String DATA_SCOPE_ALL = "1";
    public static final String DATA_SCOPE_CUSTOM = "2";
    public static final String DATA_SCOPE_DEPT = "3";
    public static final String DATA_SCOPE_DEPT_AND_CHILD = "4";
    public static final String DATA_SCOPE_SELF = "5";
    public static final String DATA_SCOPE = "dataScope";

    @Before(value="@annotation(controllerDataScope)")
    public void doBefore(JoinPoint point, DataScope controllerDataScope) throws Throwable {
        this.clearDataScope(point);
        this.handleDataScope(point, controllerDataScope);
    }

    protected void handleDataScope(JoinPoint joinPoint, DataScope controllerDataScope) {
        BaseSecurityUser loginUser = UserContextHolder.getUser();
        if (StringUtils.isNotNull((Object)loginUser) && !loginUser.isAdmin()) {
            DataScopeAspect.dataScopeFilter(joinPoint, loginUser, controllerDataScope.deptAlias(), controllerDataScope.userAlias());
        }
    }

    public static void dataScopeFilter(JoinPoint joinPoint, BaseSecurityUser user, String deptAlias, String userAlias) {
    }

    private void clearDataScope(JoinPoint joinPoint) {
    }
}

