/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.local;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.taotao.boot.common.model.BaseSecurityUser;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.NestedPermission;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.Permission;
import java.util.Optional;

public class DataPermContextHolder {
    private static final ThreadLocal<Permission> PERMISSION_LOCAL = new TransmittableThreadLocal();
    private static final ThreadLocal<NestedPermission> NESTED_PERMISSION_LOCAL = new TransmittableThreadLocal();
    private static final ThreadLocal<BaseSecurityUser> USER_DETAIL_LOCAL = new TransmittableThreadLocal();

    public static void putPermission(Permission permission) {
        PERMISSION_LOCAL.set(permission);
    }

    public static Permission getPermission() {
        return PERMISSION_LOCAL.get();
    }

    public static void putNestedPermission(NestedPermission nestedPermission) {
        NESTED_PERMISSION_LOCAL.set(nestedPermission);
    }

    public static NestedPermission getNestedPermission() {
        return NESTED_PERMISSION_LOCAL.get();
    }

    public static void putUserDetail(BaseSecurityUser dataPerm) {
        USER_DETAIL_LOCAL.set(dataPerm);
    }

    public static Optional<BaseSecurityUser> getUserDetail() {
        return Optional.ofNullable(USER_DETAIL_LOCAL.get());
    }

    public static void clearUserAndPermission() {
        USER_DETAIL_LOCAL.remove();
        PERMISSION_LOCAL.remove();
    }

    public static void clearNestedPermission() {
        NESTED_PERMISSION_LOCAL.remove();
    }
}

