/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.scope;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.taotao.boot.common.exception.BusinessException;
import com.taotao.boot.common.holder.UserContextHolder;
import com.taotao.boot.common.model.BaseSecurityUser;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.NestedPermission;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.Permission;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.code.DataScopeEnum;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.configuration.DataPermProperties;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.local.DataPermContextHolder;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.scope.DataPermScope;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.scope.DataPermScopeHandler;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Component;

@Component
public class DataScopeInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    public static final String CREATOR = "create_by";
    private final DataPermProperties dataPermProperties;
    private final DataPermScopeHandler dataPermScopeHandler;

    public DataScopeInterceptor(DataPermProperties dataPermProperties, DataPermScopeHandler dataPermScopeHandler) {
        this.dataPermProperties = dataPermProperties;
        this.dataPermScopeHandler = dataPermScopeHandler;
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (!this.dataPermProperties.isEnableDataPerm()) {
            return;
        }
        NestedPermission nestedPermission = DataPermContextHolder.getNestedPermission();
        if (Objects.nonNull(nestedPermission) && !nestedPermission.dataScope()) {
            return;
        }
        Permission permission = DataPermContextHolder.getPermission();
        if (Objects.isNull(permission) || !permission.dataScope()) {
            return;
        }
        boolean admin = DataPermContextHolder.getUserDetail().map(BaseSecurityUser::getAdmin).orElseThrow(() -> {
            throw new BusinessException("\u7528\u6237\u672a\u767b\u5f55");
        });
        if (admin) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
    }

    protected void setWhere(PlainSelect plainSelect) {
        Expression sqlSegment = this.dataScope(plainSelect.getWhere());
        if (null != sqlSegment) {
            plainSelect.setWhere(sqlSegment);
        }
    }

    protected Expression dataScope(Expression where) {
        Expression queryExpression;
        DataPermScope dataPermScope = this.dataPermScopeHandler.getDataPermScope();
        DataScopeEnum scopeType = dataPermScope.getScopeType();
        switch (scopeType) {
            case SELF: {
                queryExpression = this.selfScope();
                break;
            }
            case USER_SCOPE: {
                queryExpression = this.userScope(dataPermScope.getUserScopeIds());
                break;
            }
            case DEPT_SCOPE: {
                Expression deptScopeExpression = this.deptScope(dataPermScope.getDeptScopeIds());
                queryExpression = new OrExpression(deptScopeExpression, this.selfScope());
                break;
            }
            case DEPT_AND_USER_SCOPE: {
                queryExpression = this.deptAndUserScope(dataPermScope.getDeptScopeIds(), dataPermScope.getUserScopeIds());
                break;
            }
            case BELONG_DEPT_SCOPE: {
                queryExpression = this.userScope(UserContextHolder.getUser().getDeptIds().values().stream().map(e -> Long.valueOf((String)e.iterator().next())).collect(Collectors.toSet()));
                break;
            }
            case BELONG_DEPT_AND_SUB_SCOPE: {
                queryExpression = this.deptScope(dataPermScope.getDeptScopeIds());
                break;
            }
            case ORG_SCOPE: 
            case ALL_SCOPE: {
                return where;
            }
            default: {
                throw new BusinessException("\u4ee3\u7801\u6709\u95ee\u9898");
            }
        }
        return new AndExpression((Expression)new Parenthesis().withExpression(queryExpression), where);
    }

    protected Expression selfScope() {
        Long userId = DataPermContextHolder.getUserDetail().map(BaseSecurityUser::getUserId).orElseThrow(() -> {
            throw new BusinessException("\u7528\u6237\u672a\u767b\u5f55");
        });
        return new EqualsTo((Expression)new Column(CREATOR), (Expression)new LongValue(userId.longValue()));
    }

    protected Expression userScope(Set<Long> userScopeIds) {
        return null;
    }

    protected Expression deptScope(Set<Long> deptIds) {
        return null;
    }

    protected Expression orgScope(Set<Long> orgIds) {
        return null;
    }

    protected Expression deptAndUserScope(Set<Long> deptScopeIds, Set<Long> userScopeIds) {
        Expression deptScopeExpression = this.deptScope(deptScopeIds);
        Expression userScopeExpression = this.userScope(userScopeIds);
        return new OrExpression(deptScopeExpression, userScopeExpression);
    }
}

