/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.select;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.taotao.boot.common.exception.BusinessException;
import com.taotao.boot.common.model.BaseSecurityUser;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.Permission;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.configuration.DataPermProperties;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.perm.local.DataPermContextHolder;
import java.util.Objects;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Component;

@Component
public class SelectFieldPermInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private final DataPermProperties dataPermProperties;

    public SelectFieldPermInterceptor(DataPermProperties dataPermProperties) {
        this.dataPermProperties = dataPermProperties;
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        if (!this.dataPermProperties.isEnableSelectFieldPerm()) {
            return;
        }
        Permission permission = DataPermContextHolder.getPermission();
        if (Objects.isNull(permission) || !permission.selectField()) {
            return;
        }
        boolean admin = DataPermContextHolder.getUserDetail().map(BaseSecurityUser::isAdmin).orElseThrow(() -> {
            throw new BusinessException("\u7528\u6237\u672a\u767b\u5f55");
        });
        if (admin) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
    }
}

