/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.aspect;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.annotation.DataScope;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.exception.NoDataException;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.model.DataScopeInfo;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.service.MarkService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataScopeAspect {
    @Autowired
    private MarkService dataScopeService;
    public static ThreadLocal<DataScopeParam> threadLocal = new ThreadLocal();

    public static DataScopeParam getDataScopeParam() {
        return threadLocal.get();
    }

    @Pointcut(value="@annotation(com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.annotation.DataScope)")
    public void methodPointCut() {
    }

    @After(value="methodPointCut()")
    public void clearThreadLocal() {
        threadLocal.remove();
        LogUtils.debug((String)"threadLocal.remove()", (Object[])new Object[0]);
    }

    @Before(value="methodPointCut()")
    public void doBefore(JoinPoint point) {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        DataScope dataScope = method.getAnnotation(DataScope.class);
        try {
            if (dataScope != null) {
                String scopeName = dataScope.value();
                DataScopeInfo dataScopeInfo = this.dataScopeService.execRuleByName(scopeName);
                DataScopeParam dataScopeParam = new DataScopeParam();
                dataScopeParam.setDataScopeInfo(dataScopeInfo);
                threadLocal.set(dataScopeParam);
            }
        }
        catch (NoDataException e) {
            throw new NoDataException(e.getMessage());
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            throw new RuntimeException("\u6570\u636e\u6743\u9650 method \u5207\u9762\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    @Pointcut(value="execution(* *(.., @com.gitee.whzzone.common.annotation.DataScope (*), ..))")
    public void parameterPointCut() {
    }

    @Around(value="parameterPointCut()")
    public Object doAround(ProceedingJoinPoint point) {
        try {
            Object[] args = point.getArgs();
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            Annotation[][] parameterAnnotations = methodSignature.getMethod().getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Annotation[] annotations = parameterAnnotations[i];
                Class parameterType = methodSignature.getParameterTypes()[i];
                int index = -1;
                for (int k = 0; k < annotations.length; ++k) {
                    if (!(annotations[k] instanceof DataScope)) continue;
                    index = k;
                    break;
                }
                if (index < 0) continue;
                if (parameterType != DataScopeInfo.class) {
                    throw new RuntimeException("\u4f7f\u7528@DataScope\u7684\u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u662f\uff1aDataScopeInfo.class \u7c7b\u578b");
                }
                DataScope dataScope = (DataScope)annotations[index];
                String scopeName = dataScope.value();
                DataScopeInfo dataScopeInfo = this.dataScopeService.execRuleByName(scopeName);
                args[i] = dataScopeInfo;
            }
            return point.proceed(args);
        }
        catch (NoDataException e) {
            throw new NoDataException();
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            throw new RuntimeException("\u6570\u636e\u6743\u9650 \u5f62\u53c2 \u5207\u9762\u9519\u8bef\uff1a" + e.getMessage());
        }
        catch (Throwable e) {
            LogUtils.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class DataScopeParam {
        private DataScopeInfo dataScopeInfo;

        public DataScopeInfo getDataScopeInfo() {
            return this.dataScopeInfo;
        }

        public void setDataScopeInfo(DataScopeInfo dataScopeInfo) {
            this.dataScopeInfo = dataScopeInfo;
        }
    }
}

