/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.service;

import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.enums.ProvideTypeEnum;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.model.DataScopeInfo;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.model.Mark;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.model.MarkDto;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.model.MarkQuery;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.model.PageData;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.model.RoleMark;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.model.Rule;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.model.RuleDto;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.service.MarkService;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class MarkServiceImpl
implements MarkService {
    @Autowired
    private ApplicationContext context;

    @Override
    public Rule getByName(String name) {
        return null;
    }

    @Override
    public DataScopeInfo execRuleByEntity(Rule entity) {
        return this.execRuleHandler(entity);
    }

    private DataScopeInfo execRuleHandler(Rule rule) {
        if (rule == null) {
            throw new RuntimeException("\u6570\u636e\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        RuleDto dto = new RuleDto();
        BeanUtil.copyProperties((Object)rule, (Object)dto, (String[])new String[0]);
        DataScopeInfo info = new DataScopeInfo();
        info.setDto(dto);
        if (rule.getProvideType().equals(ProvideTypeEnum.VALUE.getCode())) {
            info.setDto(dto);
            return info;
        }
        if (rule.getProvideType().equals(ProvideTypeEnum.METHOD.getCode())) {
            try {
                Class<?> clazz;
                Method targetMethod;
                Class[] paramsTypes = null;
                Object[] argValues = null;
                if (StrUtil.isNotBlank((CharSequence)rule.getFormalParam()) && StrUtil.isNotBlank((CharSequence)rule.getActualParam())) {
                    int i;
                    String[] actualArray;
                    String[] formalArray = rule.getFormalParam().split(";");
                    if (formalArray.length != (actualArray = rule.getActualParam().split(";")).length) {
                        throw new RuntimeException("\u5f62\u53c2\u6570\u91cf\u4e0e\u5b9e\u53c2\u6570\u91cf\u4e0d\u7b26\u5408");
                    }
                    paramsTypes = new Class[formalArray.length];
                    for (i = 0; i < formalArray.length; ++i) {
                        paramsTypes[i] = Class.forName(formalArray[i].trim());
                    }
                    argValues = new Object[actualArray.length];
                    for (i = 0; i < actualArray.length; ++i) {
                        argValues[i] = JSONObject.parseObject((String)actualArray[i], (Class)paramsTypes[i]);
                    }
                }
                if (Modifier.isStatic((targetMethod = (clazz = Class.forName(rule.getClassName())).getDeclaredMethod(rule.getMethodName(), paramsTypes)).getModifiers())) {
                    targetMethod.setAccessible(true);
                    info.setIdList((List)targetMethod.invoke(null, argValues));
                    return info;
                }
                try {
                    Object instance = this.context.getBean(Class.forName(rule.getClassName()));
                    Class<?> beanClazz = instance.getClass();
                    Method beanClazzMethod = beanClazz.getDeclaredMethod(rule.getMethodName(), paramsTypes);
                    info.setIdList((List)beanClazzMethod.invoke(instance, argValues));
                    return info;
                }
                catch (NoSuchBeanDefinitionException e) {
                    Object obj = clazz.newInstance();
                    info.setIdList((List)targetMethod.invoke(obj, argValues));
                    return info;
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("\u914d\u7f6e\u4e86\u4e0d\u5b58\u5728\u7684\u65b9\u6cd5");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("\u914d\u7f6e\u4e86\u4e0d\u5b58\u5728\u7684\u7c7b");
            }
            catch (Exception e) {
                LogUtils.error((Throwable)e);
                throw new RuntimeException("\u5176\u4ed6\u9519\u8bef\uff1a" + e.getMessage());
            }
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u63d0\u4f9b\u7c7b\u578b");
    }

    @Override
    public DataScopeInfo execRuleByName(String name) {
        Rule rule = this.getByName(name);
        return this.execRuleHandler(rule);
    }

    @Override
    public boolean existSameName(Long id, String scopeName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Mark::getName, (Object)scopeName);
        queryWrapper.ne(id != null, Mark::getId, (Object)id);
        return true;
    }

    @Override
    public PageData<MarkDto> page(MarkQuery query) {
        return null;
    }

    @Override
    public void enabledSwitch(Long id) {
    }

    @Override
    public List<MarkDto> list(MarkQuery query) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByAsc(Mark::getSort);
        return null;
    }

    @Override
    public void removeAllByRoleIdAndMarkId(Long roleId, Long markId) {
        if (roleId == null) {
            throw new RuntimeException("roleId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (markId == null) {
            throw new RuntimeException("markId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RoleMark::getRoleId, (Object)roleId);
        queryWrapper.eq(RoleMark::getMarkId, (Object)markId);
    }

    @Override
    public boolean addRelation(Long roleId, Long markId, Long ruleId) {
        if (roleId == null) {
            throw new RuntimeException("roleId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (markId == null) {
            throw new RuntimeException("markId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ruleId == null) {
            throw new RuntimeException("ruleId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RoleMark entity = new RoleMark();
        entity.setRoleId(roleId);
        entity.setMarkId(markId);
        entity.setRuleId(ruleId);
        return true;
    }
}

