/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.util;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.annotation.Query;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.annotation.QueryOrder;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.annotation.QuerySort;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.annotation.SelectColumn;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascopeother.enums.ExpressionEnum;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.dromara.hutool.core.text.StrUtil;

public class QueryUtils {
    public static <Q, T> QueryWrapper<T> queryWrapperHandler(Q q) {
        try {
            Class<?> qClass = q.getClass();
            Field[] fields = qClass.getDeclaredFields();
            QueryWrapper queryWrapper = new QueryWrapper();
            HashMap<String, Field[]> betweenFieldMap = new HashMap<String, Field[]>();
            SelectColumn selectColumn = qClass.getAnnotation(SelectColumn.class);
            if (selectColumn != null && selectColumn.value() != null && selectColumn.value().length > 0) {
                Object[] strings = selectColumn.value();
                for (int i = 0; i < strings.length; ++i) {
                    strings[i] = StrUtil.toUnderlineCase((CharSequence)strings[i]);
                }
                queryWrapper.select(strings);
            }
            String sortColumn = "";
            String sortOrder = "";
            for (Field field : fields) {
                String columnName;
                Query query;
                QueryOrder queryOrder;
                field.setAccessible(true);
                Object value = field.get(q);
                if (Objects.isNull(value) || String.valueOf(value).equals("null") || value.equals("")) continue;
                QuerySort querySort = field.getDeclaredAnnotation(QuerySort.class);
                if (querySort != null) {
                    String paramValue = (String)field.get(q);
                    String string = sortColumn = paramValue.isEmpty() ? querySort.value() : paramValue;
                }
                if ((queryOrder = field.getDeclaredAnnotation(QueryOrder.class)) != null) {
                    String paramValue = (String)field.get(q);
                    String string = sortOrder = paramValue.isEmpty() ? queryOrder.value() : paramValue;
                }
                if ((query = field.getDeclaredAnnotation(Query.class)) == null) continue;
                String string = columnName = StrUtil.isBlank((CharSequence)query.column()) ? StrUtil.toUnderlineCase((CharSequence)field.getName()) : query.column();
                if (query.expression().equals((Object)ExpressionEnum.EQ)) {
                    queryWrapper.eq((Object)columnName, value);
                    continue;
                }
                if (query.expression().equals((Object)ExpressionEnum.NE)) {
                    queryWrapper.ne((Object)columnName, value);
                    continue;
                }
                if (query.expression().equals((Object)ExpressionEnum.LIKE)) {
                    queryWrapper.like((Object)columnName, value);
                    continue;
                }
                if (query.expression().equals((Object)ExpressionEnum.GT)) {
                    queryWrapper.gt((Object)columnName, value);
                    continue;
                }
                if (query.expression().equals((Object)ExpressionEnum.GE)) {
                    queryWrapper.ge((Object)columnName, value);
                    continue;
                }
                if (query.expression().equals((Object)ExpressionEnum.LT)) {
                    queryWrapper.lt((Object)columnName, value);
                    continue;
                }
                if (query.expression().equals((Object)ExpressionEnum.LE)) {
                    queryWrapper.le((Object)columnName, value);
                    continue;
                }
                if (query.expression().equals((Object)ExpressionEnum.IN)) {
                    queryWrapper.in((Object)columnName, new Object[]{value});
                    continue;
                }
                if (query.expression().equals((Object)ExpressionEnum.NOT_IN)) {
                    queryWrapper.notIn((Object)columnName, new Object[]{value});
                    continue;
                }
                if (query.expression().equals((Object)ExpressionEnum.IS_NULL)) {
                    queryWrapper.isNull((Object)columnName);
                    continue;
                }
                if (query.expression().equals((Object)ExpressionEnum.NOT_NULL)) {
                    queryWrapper.isNotNull((Object)columnName);
                    continue;
                }
                if (!query.expression().equals((Object)ExpressionEnum.BETWEEN)) continue;
                if (betweenFieldMap.containsKey(columnName)) {
                    Field[] f = (Field[])betweenFieldMap.get(columnName);
                    Field[] tempList = new Field[]{f[0], field};
                    betweenFieldMap.put(columnName, tempList);
                    continue;
                }
                betweenFieldMap.put(columnName, new Field[]{field});
            }
            Set keySet = betweenFieldMap.keySet();
            for (String key : keySet) {
                Field[] itemFieldList = (Field[])betweenFieldMap.get(key);
                if (itemFieldList.length != 2) {
                    throw new IllegalArgumentException("\u67e5\u8be2\u53c2\u6570\u6570\u91cf\u5bf9\u5e94\u5f02\u5e38");
                }
                Field field1 = itemFieldList[0];
                Field field2 = itemFieldList[1];
                Query query1 = field1.getDeclaredAnnotation(Query.class);
                if (field1.get(q) instanceof Date) {
                    if (query1.left()) {
                        queryWrapper.apply("date_format(" + key + ",'%y%m%d') >= date_format({0},'%y%m%d')", new Object[]{field1.get(q)});
                        queryWrapper.apply("date_format(" + key + ",'%y%m%d') <= date_format({0},'%y%m%d')", new Object[]{field2.get(q)});
                        continue;
                    }
                    queryWrapper.apply("date_format(" + key + ",'%y%m%d') <= date_format({0},'%y%m%d')", new Object[]{field1.get(q)});
                    queryWrapper.apply("date_format(" + key + ",'%y%m%d') >= date_format({0},'%y%m%d')", new Object[]{field2.get(q)});
                    continue;
                }
                if (query1.left()) {
                    queryWrapper.between((Object)key, field1.get(q), field2.get(q));
                    continue;
                }
                queryWrapper.between((Object)key, field2.get(q), field1.get(q));
            }
            if (sortOrder.equalsIgnoreCase("desc")) {
                queryWrapper.orderByDesc(StrUtil.isNotBlank((CharSequence)sortColumn), (Object)StrUtil.toUnderlineCase((CharSequence)sortColumn));
            } else {
                queryWrapper.orderByAsc(StrUtil.isNotBlank((CharSequence)sortColumn), (Object)StrUtil.toUnderlineCase((CharSequence)sortColumn));
            }
            return queryWrapper;
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }
}

