/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.tenant;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.taotao.boot.common.holder.TenantContextHolder;
import com.taotao.boot.data.mybatis.properties.MybatisPlusInterceptorProperties;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;

public class MultiTenantLineHandler
implements TenantLineHandler {
    private MybatisPlusInterceptorProperties.MultiTenant tenantProperties;

    public MultiTenantLineHandler(MybatisPlusInterceptorProperties.MultiTenant tenantProperties) {
        this.tenantProperties = tenantProperties;
    }

    public Expression getTenantId() {
        String tenantId = TenantContextHolder.getTenant();
        if (tenantId != null) {
            return new LongValue(tenantId);
        }
        return new NullValue();
    }

    public String getTenantIdColumn() {
        return this.tenantProperties.getColumn();
    }

    public boolean ignoreTable(String tableName) {
        return this.tenantProperties.getIgnoreTables().contains(tableName);
    }
}

