/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.tenant;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.taotao.boot.data.mybatis.properties.MybatisPlusInterceptorProperties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class MultiTenantLineInnerInterceptor
extends TenantLineInnerInterceptor {
    private MybatisPlusInterceptorProperties.MultiTenant tenantProperties;

    public MultiTenantLineInnerInterceptor(TenantLineHandler tenantLineHandler, MybatisPlusInterceptorProperties.MultiTenant tenantProperties) {
        super(tenantLineHandler);
        this.tenantProperties = tenantProperties;
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        if (this.isIgnoreMappedStatement(ms.getId())) {
            return;
        }
        super.beforeQuery(executor, ms, parameter, rowBounds, resultHandler, boundSql);
    }

    private boolean isIgnoreMappedStatement(String msId) {
        return this.tenantProperties.getIgnoreSqls().stream().anyMatch(e -> e.equalsIgnoreCase(msId));
    }
}

