/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.mybatisplus.interceptor.tenant;

import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.taotao.boot.common.holder.TenantContextHolder;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.mybatisplus.ReplaceSql;
import com.taotao.boot.data.mybatis.properties.MybatisPlusInterceptorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.dromara.hutool.core.text.StrUtil;

public class SchemaInterceptor
implements InnerInterceptor {
    private final MybatisPlusInterceptorProperties.MultiTenant tenantProperties;

    public SchemaInterceptor(MybatisPlusInterceptorProperties.MultiTenant tenantProperties) {
        this.tenantProperties = tenantProperties;
    }

    protected String changeTable(String sql) {
        String tenantCode = TenantContextHolder.getTenant();
        String database = TenantContextHolder.getDatabase();
        if (StrUtil.isEmpty((CharSequence)tenantCode)) {
            return sql;
        }
        Object schemaName = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{StrUtil.isEmpty((CharSequence)database) ? this.tenantProperties.getTenantDatabasePrefix() : database, tenantCode});
        if (StrUtil.isNotEmpty((CharSequence)this.tenantProperties.getOwner())) {
            schemaName = (String)schemaName + "." + this.tenantProperties.getOwner();
        }
        return ReplaceSql.replaceSql(this.tenantProperties.getDbType(), (String)schemaName, sql);
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE || sct == SqlCommandType.SELECT) {
            if (InterceptorIgnoreHelper.willIgnoreDynamicTableName((String)ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            LogUtils.debug((String)"\u672a\u66ff\u6362\u524d\u7684sql: {}", (Object[])new Object[]{mpBs.sql()});
            mpBs.sql(this.changeTable(mpBs.sql()));
        }
        TenantContextHolder.clearDatabase();
    }
}

