/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.core;

import com.taotao.boot.data.mybatis.sharding.config.DataSourceProps;
import com.taotao.boot.data.mybatis.sharding.factories.HikariCPFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.sql.DataSource;

public class DatasourceManager {
    private static final Map<String, DataSource> DATASOURCE_MAP = new ConcurrentHashMap<String, DataSource>();
    private final DataSourceProps props;

    public DataSource get(String name) {
        return DATASOURCE_MAP.get(name);
    }

    public void foreach(BiConsumer<String, DataSource> consumer) {
        for (Map.Entry<String, DataSource> entry : DATASOURCE_MAP.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public DatasourceManager(DataSourceProps props) {
        this.props = props;
        this.init();
    }

    public void init() {
        DATASOURCE_MAP.putAll(HikariCPFactory.createAllMap(this.props));
    }
}

