/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.core;

import com.taotao.boot.data.mybatis.sharding.annos.Sharding;
import com.taotao.boot.data.mybatis.sharding.annos.ShardingKey;
import com.taotao.boot.data.mybatis.sharding.core.SqlSessionFactoryManager;
import com.taotao.boot.data.mybatis.sharding.factories.ClassManager;
import com.taotao.boot.data.mybatis.sharding.utils.ExpressionUtil;
import com.taotao.boot.data.mybatis.sharding.utils.NameUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class ShardingCoreHandler
implements InvocationHandler {
    private final SqlSessionFactoryManager sessionFactoryManager;
    private final Sharding sharding;
    private final Class<?> clz;
    private final ClassManager classManager;

    public ShardingCoreHandler(Sharding s, SqlSessionFactoryManager sm, Class<?> clz, ClassManager classManager) {
        this.sessionFactoryManager = sm;
        this.sharding = s;
        this.clz = clz;
        this.classManager = classManager;
    }

    private static long getShardingKeyFromArgs(Method method, Object[] args) throws IllegalAccessException {
        Parameter[] params = method.getParameters();
        int i = 0;
        Object shardingKey = null;
        for (Parameter p : params) {
            Annotation[] methodAnnos;
            for (Annotation a : methodAnnos = p.getAnnotations()) {
                if (!(a instanceof ShardingKey)) continue;
                shardingKey = args[i];
                break;
            }
            if (shardingKey != null) break;
            Field[] fields = p.getType().getDeclaredFields();
            int j = 0;
            for (Field f : fields) {
                Annotation[] fieldAnnos;
                for (Annotation a : fieldAnnos = f.getAnnotations()) {
                    if (!(a instanceof ShardingKey)) continue;
                    f.setAccessible(true);
                    shardingKey = f.get(args[i]);
                    break;
                }
                if (shardingKey != null) break;
                ++j;
            }
            ++i;
        }
        if (shardingKey == null) {
            throw new RuntimeException("sharding key should not be null");
        }
        return (Long)shardingKey;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long shardingKeyVal = ShardingCoreHandler.getShardingKeyFromArgs(method, args);
        String dsName = this.sharding.datasource()[0];
        if (!this.sharding.dbRule().isEmpty()) {
            dsName = ExpressionUtil.eval(this.sharding.dbRule(), this.sharding.shardingKey(), shardingKeyVal);
        }
        String className = NameUtils.buildClassName(dsName, this.clz.getCanonicalName());
        Class<?> mapperClass = this.classManager.getClass(dsName, className);
        Object mapper = this.sessionFactoryManager.getMapper(mapperClass);
        if (!this.sharding.tableRule().isEmpty()) {
            String tableName = ExpressionUtil.eval(this.sharding.tableRule(), this.sharding.shardingKey(), shardingKeyVal);
            Object[] builtArgs = this.buildArgs(args, tableName);
            Method targetMethod = this.classManager.getMethod(dsName, className, method.getName());
            return targetMethod.invoke(mapper, builtArgs);
        }
        if (!this.sharding.dbRule().isEmpty()) {
            Method targetMethod = this.classManager.getMethod(dsName, className, method.getName());
            return targetMethod.invoke(mapper, args);
        }
        return null;
    }

    private Object[] buildArgs(Object[] args, String tableName) {
        Object[] result = new Object[args.length + 1];
        result[0] = tableName;
        System.arraycopy(args, 0, result, 1, args.length);
        return result;
    }
}

