/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.core;

import com.taotao.boot.data.mybatis.sharding.annos.Sharding;
import com.taotao.boot.data.mybatis.sharding.core.DatasourceManager;
import com.taotao.boot.data.mybatis.sharding.utils.ExpressionUtil;
import com.taotao.boot.data.mybatis.sharding.utils.ResourceUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class ShardingTransactionManager {
    private static final Map<String, DataSourceTransactionManager> TRANS_MAP = new HashMap<String, DataSourceTransactionManager>();
    private final DatasourceManager datasourceManager;

    public ShardingTransactionManager(DatasourceManager ds) {
        this.datasourceManager = ds;
        this.init();
    }

    private void init() {
        this.datasourceManager.foreach((name, ds) -> TRANS_MAP.put((String)name, new DataSourceTransactionManager(ds)));
    }

    public PlatformTransactionManager getTransactionManager(Class<?> mapperClz, long shardingVal) {
        Sharding sharding = ResourceUtil.getShardingAnno(mapperClz);
        if (sharding == null) {
            throw new IllegalArgumentException("this mapper is illegal");
        }
        if (sharding.dbRule().isEmpty()) {
            return (PlatformTransactionManager)TRANS_MAP.get(sharding.datasource()[0]);
        }
        String dsName = ExpressionUtil.eval(sharding.dbRule(), sharding.shardingKey(), shardingVal);
        return (PlatformTransactionManager)TRANS_MAP.get(dsName);
    }

    public PlatformTransactionManager getTransactionManager(String dbRule, String key, long shardingVal) {
        String dsName = ExpressionUtil.eval(dbRule, key, shardingVal);
        return (PlatformTransactionManager)TRANS_MAP.get(dsName);
    }

    public PlatformTransactionManager getTransactionManager(String ds) {
        return (PlatformTransactionManager)TRANS_MAP.get(ds);
    }
}

