/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.core;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.sharding.annos.Sharding;
import com.taotao.boot.data.mybatis.sharding.core.DatasourceManager;
import com.taotao.boot.data.mybatis.sharding.utils.Pair;
import com.taotao.boot.data.mybatis.sharding.utils.ResourceUtil;
import com.taotao.boot.data.mybatis.sharding.utils.XmlUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class SqlSessionFactoryManager {
    private static final Map<String, SqlSessionFactoryBean> SESSION_FACTORY_MAP = new ConcurrentHashMap<String, SqlSessionFactoryBean>();
    private static final Map<String, SqlSessionTemplate> TEMPLATE_MAP = new ConcurrentHashMap<String, SqlSessionTemplate>();
    private static final Map<String, String> RES_MAP = new ConcurrentHashMap<String, String>();
    private static final ResourcePatternResolver RESOLVER = new PathMatchingResourcePatternResolver();
    private final List<Class<?>> classes;
    private final DatasourceManager datasourceManager;
    private Interceptor interceptor;

    public SqlSessionFactoryManager(List<Class<?>> cs, DatasourceManager dsManager) {
        this.classes = cs;
        this.datasourceManager = dsManager;
        this.init();
    }

    public SqlSessionFactoryBean createSqlSession(String name, DataSource dataSource, Resource ... locations) {
        Configuration configuration = new Configuration();
        configuration.setMapUnderscoreToCamelCase(true);
        if (this.interceptor != null) {
            configuration.addInterceptor(this.interceptor);
        }
        SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();
        factoryBean.setMapperLocations(locations);
        factoryBean.setDataSource(dataSource);
        factoryBean.setConfiguration(configuration);
        return factoryBean;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void init() {
        this.datasourceManager.foreach((String name, DataSource ds) -> {
            Map<String, Resource> resources = this.extractResources((String)name);
            for (Map.Entry<String, Resource> entry : resources.entrySet()) {
                RES_MAP.put(entry.getKey(), (String)name);
            }
            SqlSessionFactoryBean sessionFactory = this.createSqlSession((String)name, (DataSource)ds, SqlSessionFactoryManager.toArray(resources.values()));
            SESSION_FACTORY_MAP.putIfAbsent((String)name, sessionFactory);
            SqlSessionTemplate template = null;
            try {
                template = new SqlSessionTemplate(Objects.requireNonNull(sessionFactory.getObject()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            TEMPLATE_MAP.putIfAbsent((String)name, template);
        });
    }

    public <T> T getMapper(Class<?> clz) {
        SqlSessionTemplate template = TEMPLATE_MAP.get(RES_MAP.get(clz.getCanonicalName()));
        if (template == null) {
            throw new RuntimeException("datasource init failed, template null!");
        }
        return (T)template.getMapper(clz);
    }

    private Map<String, Resource> extractResources(String dsName) {
        HashMap<String, Resource> result = new HashMap<String, Resource>();
        for (Class<?> clz : this.classes) {
            Resource[] resources;
            Sharding sharding = ResourceUtil.getShardingAnno(clz);
            if (sharding == null || !SqlSessionFactoryManager.contains(sharding.datasource(), dsName)) continue;
            boolean isSharding = !sharding.dbRule().isEmpty() || !sharding.tableRule().isEmpty();
            try {
                resources = RESOLVER.getResources(sharding.mapperLocation());
            }
            catch (IOException e) {
                LogUtils.warn((String)"extractShardingResources - mapper location error", (Object[])new Object[]{e});
                continue;
            }
            for (Resource r : resources) {
                if (!XmlUtils.extractNamespace(r).equals(clz.getCanonicalName())) continue;
                if (isSharding) {
                    Pair<String, Resource> resourcePair = XmlUtils.changeMapperNameSpace(dsName, r);
                    if (resourcePair == null) continue;
                    result.putIfAbsent(resourcePair.left(), resourcePair.right());
                    continue;
                }
                result.putIfAbsent(XmlUtils.extractNamespace(r), r);
            }
        }
        return result;
    }

    private static boolean contains(String[] arr, String element) {
        if (arr == null || element == null) {
            return false;
        }
        for (String e : arr) {
            if (!element.equals(e)) continue;
            return true;
        }
        return false;
    }

    private static Resource[] toArray(Collection<Resource> collection) {
        if (collection == null || collection.isEmpty()) {
            return new Resource[0];
        }
        Resource[] result = new Resource[collection.size()];
        int i = 0;
        Iterator<Resource> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Resource e;
            result[i] = e = iterator.next();
            ++i;
        }
        return result;
    }

    public void foreach(BiConsumer<String, SqlSessionTemplate> consumer) {
        TEMPLATE_MAP.forEach(consumer);
    }
}

