/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.factories;

import com.taotao.boot.data.mybatis.sharding.annos.Sharding;
import com.taotao.boot.data.mybatis.sharding.utils.ClassScanUtils;
import com.taotao.boot.data.mybatis.sharding.utils.NameUtils;
import com.taotao.boot.data.mybatis.sharding.utils.ResourceUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassManager {
    private static final Map<String, Map<String, Class<?>>> CLASS_MAP = new HashMap();
    private static final Map<String, Map<String, Map<String, Method>>> METHOD_CACHE = new HashMap<String, Map<String, Map<String, Method>>>();
    private final List<Class<?>> classes;

    public ClassManager(List<Class<?>> cs) {
        this.classes = cs;
        this.init();
    }

    private void init() {
        for (Class<?> clz : this.classes) {
            Sharding sharding = ResourceUtil.getShardingAnno(clz);
            if (!sharding.tableRule().isEmpty()) {
                for (String dsName : sharding.datasource()) {
                    this.generate(dsName, clz, true);
                }
                continue;
            }
            if (sharding.dbRule().isEmpty()) continue;
            for (String dsName : sharding.datasource()) {
                this.generate(dsName, clz, false);
            }
        }
    }

    private void generate(String dsName, Class<?> clz, boolean sharding) {
        Map<String, Method> methodMap;
        Map<String, Class<?>> dsMap = CLASS_MAP.get(dsName);
        if (dsMap == null) {
            dsMap = new HashMap();
        }
        Class<?> genClz = ClassScanUtils.generateMapperViaMapper(clz, dsName, sharding);
        String name = NameUtils.buildClassName(dsName, clz.getCanonicalName());
        dsMap.put(name, genClz);
        CLASS_MAP.put(dsName, dsMap);
        Map<String, Map<String, Method>> dsMethodMap = METHOD_CACHE.get(dsName);
        if (dsMethodMap == null) {
            dsMethodMap = new HashMap<String, Map<String, Method>>();
        }
        if ((methodMap = dsMethodMap.get(name)) == null) {
            methodMap = new HashMap<String, Method>();
        }
        for (Method m : genClz.getDeclaredMethods()) {
            methodMap.put(m.getName(), m);
        }
        dsMethodMap.put(name, methodMap);
        METHOD_CACHE.put(dsName, dsMethodMap);
    }

    public Class<?> getClass(String dsName, String className) {
        return CLASS_MAP.get(dsName).get(className);
    }

    public Method getMethod(String dsName, String className, String name) {
        return METHOD_CACHE.get(dsName).get(className).get(name);
    }
}

