/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.factories;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.sharding.config.DataSourceProps;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class HikariCPFactory {
    public static DataSource createOne(DataSourceProps.HikariProps props) {
        HikariConfig config = new HikariConfig();
        config.setConnectionTestQuery(props.getConnectionTestQuery());
        config.setConnectionTimeout(props.getConnectionTimeout());
        config.setDriverClassName(props.getDriverClassName());
        config.setPoolName(props.getName());
        config.setJdbcUrl(props.getJdbcUrl());
        config.setUsername(props.getUsername());
        config.setPassword(props.getPassword());
        config.setMaximumPoolSize(props.getMaximumPoolSize());
        config.addDataSourceProperty("dataSource.cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("dataSource.prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("dataSource.prepStmtCacheSqlLimit", (Object)"2048");
        config.addDataSourceProperty("dataSource.useServerPrepStmts", (Object)"true");
        LogUtils.info((String)"createOne ----  datasource:{} of type:{} created...", (Object[])new Object[]{props.getName(), props.getDriverClassName()});
        return new HikariDataSource(config);
    }

    public static List<DataSource> createAll(DataSourceProps props) {
        if (props.getList() == null || props.getList().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<DataSource> result = new ArrayList<DataSource>(props.getList().length);
        for (DataSourceProps.HikariProps prop : props.getList()) {
            result.add(HikariCPFactory.createOne(prop));
        }
        return result;
    }

    public static Map<String, DataSource> createAllMap(DataSourceProps props) {
        if (props.getList() == null || props.getList().length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, DataSource> result = new HashMap<String, DataSource>(props.getList().length, 1.0f);
        for (DataSourceProps.HikariProps prop : props.getList()) {
            result.put(prop.getName(), HikariCPFactory.createOne(prop));
        }
        return result;
    }
}

