/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.factories;

import com.taotao.boot.data.mybatis.sharding.annos.Sharding;
import com.taotao.boot.data.mybatis.sharding.core.ShardingCoreHandler;
import com.taotao.boot.data.mybatis.sharding.core.SqlSessionFactoryManager;
import com.taotao.boot.data.mybatis.sharding.factories.ClassManager;
import com.taotao.boot.data.mybatis.sharding.utils.ResourceUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ShardingMapperFactory {
    private static final Map<Class<?>, ShardingCoreHandler> HANDLER_MAP = new ConcurrentHashMap();
    private final SqlSessionFactoryManager sessionFactoryManager;
    private final ClassManager classManager;

    public ShardingMapperFactory(SqlSessionFactoryManager sessionFactoryManager, ClassManager classManager) {
        this.sessionFactoryManager = sessionFactoryManager;
        this.classManager = classManager;
    }

    public <T> T createProxy(Class<T> clz) {
        boolean isSharding;
        Sharding sharding = ResourceUtil.getShardingAnno(clz);
        boolean bl = isSharding = !sharding.dbRule().isEmpty() || !sharding.tableRule().isEmpty();
        if (isSharding) {
            ShardingCoreHandler handler = HANDLER_MAP.get(clz);
            if (handler == null) {
                handler = new ShardingCoreHandler(sharding, this.sessionFactoryManager, clz, this.classManager);
                HANDLER_MAP.putIfAbsent(clz, handler);
            }
            return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clz}, (InvocationHandler)handler);
        }
        return null;
    }
}

