/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.starter;

import com.taotao.boot.data.mybatis.sharding.annos.EnableSharding;
import com.taotao.boot.data.mybatis.sharding.config.DataSourceProps;
import com.taotao.boot.data.mybatis.sharding.core.DatasourceManager;
import com.taotao.boot.data.mybatis.sharding.core.ShardingTransactionManager;
import com.taotao.boot.data.mybatis.sharding.core.SqlSessionFactoryManager;
import com.taotao.boot.data.mybatis.sharding.factories.ClassManager;
import com.taotao.boot.data.mybatis.sharding.factories.ShardingMapperFactory;
import com.taotao.boot.data.mybatis.sharding.utils.Pair;
import com.taotao.boot.data.mybatis.sharding.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class ShardingStarter
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    private ConfigurableBeanFactory beanFactory;

    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    public void registerBeanDefinitions(AnnotationMetadata metaData, @NonNull BeanDefinitionRegistry registry) {
        MergedAnnotation anno = metaData.getAnnotations().get(EnableSharding.class);
        if (!anno.isPresent()) {
            return;
        }
        String[] packages = anno.getStringArray("packages");
        if (packages.length == 0) {
            return;
        }
        Pair<List<Class<?>>, List<Class<?>>> classesPair = ResourceUtil.getClassesWithAnno(packages);
        ClassManager classManager = null;
        if (!classesPair.right().isEmpty()) {
            classManager = new ClassManager(classesPair.right());
        }
        DataSourceProps datasourceCfg = this.getDatasourceCfg();
        DatasourceManager datasourceManager = new DatasourceManager(datasourceCfg);
        this.registerDatasource(datasourceManager);
        ArrayList classes = new ArrayList();
        classes.addAll((Collection)classesPair.left());
        classes.addAll((Collection)classesPair.right());
        SqlSessionFactoryManager sessionManager = new SqlSessionFactoryManager(classes, datasourceManager);
        if (classManager != null) {
            this.registerSharding(classesPair.right(), sessionManager, classManager);
        }
        if (!classesPair.left().isEmpty()) {
            this.registerNonShardingClasses(classesPair.left(), sessionManager);
        }
        this.beanFactory.registerSingleton("session_factory_manager", (Object)sessionManager);
        this.beanFactory.registerSingleton("sharding_trans_mgr", (Object)new ShardingTransactionManager(datasourceManager));
        this.beanFactory.registerSingleton("sharding_trans_def", (Object)new DefaultTransactionDefinition(0));
    }

    private void registerDatasource(DatasourceManager datasourceManager) {
        datasourceManager.foreach((name, ds) -> this.beanFactory.registerSingleton(name, ds));
    }

    private void registerSharding(List<Class<?>> classes, SqlSessionFactoryManager sessionManager, ClassManager classManager) {
        ShardingMapperFactory factory = new ShardingMapperFactory(sessionManager, classManager);
        for (Class<?> clz : classes) {
            Object mapper = factory.createProxy(clz);
            this.beanFactory.registerSingleton(clz.getCanonicalName(), mapper);
        }
    }

    private void registerNonShardingClasses(List<Class<?>> classes, SqlSessionFactoryManager sessionManager) {
        for (Class<?> clz : classes) {
            Object mapper = sessionManager.getMapper(clz);
            this.beanFactory.registerSingleton(clz.getCanonicalName(), mapper);
        }
    }

    private DataSourceProps getDatasourceCfg() {
        Environment env = (Environment)this.beanFactory.getBean(Environment.class);
        try {
            Iterable sources = ConfigurationPropertySources.get((Environment)env);
            Binder binder = new Binder(sources);
            BindResult config = binder.bind("datasource", DataSourceProps.class);
            if (config == null || config.get() == null || ((DataSourceProps)config.get()).getList() == null || ((DataSourceProps)config.get()).getList().length == 0) {
                return null;
            }
            return (DataSourceProps)config.get();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

